% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFLOMICS-Methods_07_Integration.R
\name{prepareForIntegration,RflomicsMAE-method}
\alias{prepareForIntegration,RflomicsMAE-method}
\alias{prepareForIntegration}
\title{Preparation step for integration}
\usage{
\S4method{prepareForIntegration}{RflomicsMAE}(
  object,
  omicsNames = NULL,
  rnaSeq_transfo = "limma (voom)",
  variableLists = NULL,
  group = NULL,
  method = "MOFA",
  transformData = TRUE,
  cmd = FALSE
)
}
\arguments{
\item{object}{An object of class \link{RflomicsMAE-class}.
It is expected the MAE object is produced by RFLOMICS previous analyses,
as it relies on their results.}

\item{omicsNames}{vector of characters strings,
referring to the names of the filtered table in 'object@ExperimentList'.}

\item{rnaSeq_transfo}{character string, only supports 'limma (voom)'
for now.
Transformation of the rnaSeq data from counts to continuous data.}

\item{variableLists}{list of variables to keep per dataset. Default is
keeping all features.}

\item{group}{Not implemented yet in the interface. Useful for MOFA2 run.}

\item{method}{one of MOFA or mixOmics.
Method for which the object is prepared.}

\item{transformData}{boolean.
Transform the data with the transform and normalization method?
Default is TRUE.}

\item{cmd}{used in the interface. Print cmd lines.}
}
\value{
An untrained MOFA object or a list of dataset
}
\description{
This function transforms a RflomicsMAE produced by rflomics
into an untrained MOFA object or a list to use for mixOmics.
It checks for batch effects to correct them before integration.
It also transforms RNASeq counts data into continuous data using
\code{\link[limma]{voom}}.
This is the second step into the integration.
}
\examples{
library(RFLOMICS)

# load ecoseed data
data("ecoseed.mae")

factorInfo <- data.frame(
  "factorName"   = c("Repeat", "temperature", "imbibition"),
  "factorType"   = c("batch", "Bio", "Bio")
)

# create rflomicsMAE object with ecoseed data
MAE <- RFLOMICS::createRflomicsMAE(
  projectName = "Tests",
  omicsData   = ecoseed.mae,
  omicsTypes  = c("RNAseq","proteomics","metabolomics"),
  factorInfo  = factorInfo)
names(MAE) <- c("RNAtest", "protetest", "metatest")

formulae <- generateModelFormulae( MAE) 
MAE <- setModelFormula(MAE, formulae[[1]])
contrastList <- Reduce(rbind, generateExpressionContrast(MAE)) 

MAE <- MAE |>
    setSelectedContrasts(contrastList[c(3,6,25)]) |>
    runDataProcessing(SE.name = "metatest", 
                      transformMethod = "log2",
                      normMethod = "median") |>
    runDataProcessing(SE.name = "protetest", 
                      transformMethod = "none",
                      normMethod = "median") |>
    runDiffAnalysis(SE.name = "metatest", method = "limmalmFit") |>
    runDiffAnalysis(SE.name = "protetest", method = "limmalmFit")    

# Integration using MOFA
# Prepare mofa object:
mofaObj <- prepareForIntegration(MAE,
                                 omicsNames = c("protetest", "metatest"),
                                 variableLists = rownames(MAE),
                                 method = "MOFA")
class(mofaObj)

# Integration using MixOmics
mixObj <- prepareForIntegration(MAE,
                                omicsNames = c("protetest", "metatest"),
                                variableLists = rownames(MAE),
                                method = "mixOmics")
class(mixObj)
}
