% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutational.signatures.discovery.R
\name{signaturesAssignment}
\alias{signaturesAssignment}
\title{signaturesAssignment}
\usage{
signaturesAssignment(x, beta)
}
\arguments{
\item{x}{Counts matrix for a set of n patients and m categories. These can be, e.g., SBS, MNV, CN or CN counts;
in the case of SBS it would be an n patients x 96 trinucleotides matrix.}

\item{beta}{Matrix of the discovered signatures to be used for the assignment.}
}
\value{
A list with the discovered signatures. It includes 3 elements:
             alpha: matrix of the discovered exposure values.
             beta: matrix of the discovered signatures.
             unexplained_mutations: number of unexplained mutations per sample.
}
\description{
Perform the assignment of K somatic mutational signatures provided as input to samples given a set of observed counts x.
This function can be used to estimate different types of mutational signatures such as: SBS (single base substitutions) and 
MNV (multi-nucleotide variant) (see Degasperi, Andrea, et al. 'Substitution mutational signatures in whole-genome–sequenced cancers 
in the UK population.' Science 376.6591 (2022): abl9283), CX (chromosomal instability) (see Drews, Ruben M., et al. 'A pan-cancer 
compendium of chromosomal instability.' Nature 606.7916 (2022): 976-983) and CN (copy number) signatures (see Steele, 
Christopher D., et al. 'Signatures of copy number alterations in human cancer.' Nature 606.7916 (2022): 984-991).
}
\examples{
data(background)
data(patients)
set.seed(12345)
beta <- signaturesDecomposition(x = patients[seq_len(3),seq_len(2)],
                                K = 3,
                                background_signature = background[seq_len(2)],
                                nmf_runs = 2,
                                num_processes = 1)
set.seed(12345)
res <- signaturesAssignment(x = patients[seq_len(3),seq_len(2)], beta = beta$beta[[1]])

}
