% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{updateAnnotationText}
\alias{updateAnnotationText}
\title{Update Text Annotation}
\usage{
updateAnnotationText(
  text = NULL,
  annotationName = NULL,
  x.pos = NULL,
  y.pos = NULL,
  fontSize = NULL,
  fontFamily = NULL,
  fontStyle = NULL,
  color = NULL,
  angle = NULL,
  name = NULL,
  canvas = NULL,
  z.order = NULL,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{text}{The text to be displayed}

\item{annotationName}{Name of annotation by UUID or Name}

\item{x.pos}{(optional) X position in pixels from left; default is center 
of current view}

\item{y.pos}{(optional) Y position in pixels from top; default is center 
of current view}

\item{fontSize}{(optional) Numeric value; default is 12}

\item{fontFamily}{(optional) Font family; default is Arial}

\item{fontStyle}{(optional) Font style; default is}

\item{color}{(optional) Hexidecimal color; default is #000000 (black)}

\item{angle}{(optional) Angle of text orientation; default is 0.0 
(horizontal)}

\item{name}{(optional) Name of annotation object; default is "Text"}

\item{canvas}{(optional) Canvas to display annotation, i.e., foreground 
(default) or background}

\item{z.order}{(optional) Arrangement order specified by number (larger
values are in front of smaller values); default is 0}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is 
http://localhost:1234 and the latest version of the CyREST API supported by
this version of RCy3.}
}
\value{
A named list of annotation properties, including UUID
}
\description{
Updates a text annotation to a Cytoscape network view. The object 
will also be added to the Annotation Panel in the GUI.
}
\examples{
\donttest{
updateAnnotationText("test1", "annotationName")
updateAnnotationText("test2", "annotationName", 1000, 1000, name="T2")
updateAnnotationText("test3", "annotationName", 1200, 1000, 30, "Helvetica", "bold", "#990000",
    40,name="T3", canvas="foreground",z=4)
}
}
