% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tools.R
\name{diffusionAdvanced}
\alias{diffusionAdvanced}
\title{Diffusion Advanced}
\usage{
diffusionAdvanced(
  heat.column.name = NULL,
  time = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{heat.column.name}{(optional) A node column name intended to override the 
default table column 'diffusion_input'. This represents the query vector and 
corresponds to h in the diffusion equation.}

\item{time}{(optional) The extent of spread over the network. This corresponds 
to t in the diffusion equation.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain, 
port or version to connect to the CyREST API. Default is http://localhost:1234 
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
Version number
}
\description{
Diffusion will send the selected network view and its selected nodes 
to a web-based REST service to calculate network propagation. Results are returned 
and represented by columns in the node table. Advanced operation supports
parameters.
}
\details{
Columns are created for each execution of Diffusion and their names 
are returned in the response. The nodes you would like to use as input should 
be selected. This will be used to generate the contents of the diffusion_input 
column, which represents the query vector and corresponds to h in the diffusion
equation.
}
\examples{
\donttest{
diffusionAdvanced()
}
}
