% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{ungroupAnnotation}
\alias{ungroupAnnotation}
\title{Ungroup Annotation Group}
\usage{
ungroupAnnotation(names = NULL, network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{names}{Name of annotation group by UUID or Name}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is 
http://localhost:1234 and the latest version of the CyREST API supported by 
this version of RCy3.}
}
\value{
None
}
\description{
Ungroup annotation group from the network view in Cytoscape
}
\details{
You can obtain a list of UUIDs by applying a subset function
like so: sapply(getAnnotationList(), '[[', 'uuid')
}
\examples{
\donttest{
ungroupAnnotation("016a4af1-69bc-4b99-8183-d6f118847f96")
ungroupAnnotation(c("316869a4-39fc-4731-8f45-199dec9af10d","c3621eb4-4687-490f-9396-b829dd8767d5"))
ungroupAnnotation("Group 1")
ungroupAnnotation(c("Group1","Group2", "Group3"))
}
}
