% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkViews.R
\name{getNetworkViewSuid}
\alias{getNetworkViewSuid}
\title{Get the SUID of a network view}
\usage{
getNetworkViewSuid(network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape. If a network view SUID is provided, 
then it is validated and returned.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
(\code{numeric}) Network view suid. The first (presumably only) view 
associated a network is returned.
}
\description{
Retrieve the SUID of a network view
}
\examples{
\donttest{
getNetworkViewSuid()
getNetworkViewSuid("myNetwork")
# 90
}
}
\author{
Alexander Pico
}
