% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-MetaData.R
\name{updateMetaDataProperties}
\alias{updateMetaDataProperties}
\title{Update meta-data properties}
\usage{
updateMetaDataProperties(rcx, aspectName, property)
}
\arguments{
\item{rcx}{\link[=RCX-object]{RCX} object;}

\item{aspectName}{character; name of the aspect as displayed in \code{\link{Meta-data}} (e.g. "nodes")}

\item{property}{named list; property as key-value pairs (empty list to remove all)}
}
\value{
\link[=RCX-object]{RCX} object with updated \code{\link{Meta-data}} aspect
}
\description{
The \code{\link{Meta-data}} aspect contains meta-data about the aspects in the \code{\link{RCX-object}}.
Properties that need to be fetched or updated independently of aspect data are added with this function.
}
\examples{
## prepare RCX object:
nodes = createNodes(name = c("a","b","c","d","e","f"))
edges = createEdges(source=c(1,2,0,0,0,2), 
                    target=c(2,3,1,2,5,4))
rcx = createRCX(nodes, edges)
cySubNetworks = createCySubNetworks(
  id = c(1,2),
  nodes = list("all", c(1,2,3)),
  edges = list("all", c(0,2))                    
)
rcx = updateCySubNetworks(rcx, cySubNetworks)

## add properties for edges
updateMetaDataProperties(rcx, 
                         "edges", 
                         list(some="value",
                              another="VALUE"))

## remove properties for edges
updateMetaDataProperties(rcx, 
                         "edges", 
                         list())
}
