% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Json-fromJson.R
\name{readCX}
\alias{readCX}
\alias{readJSON}
\alias{parseJSON}
\alias{processCX}
\title{Read CX from file, parse the JSON and convert it to an \link[=RCX-object]{RCX} object}
\usage{
readCX(file, verbose = FALSE, aspectClasses = getAspectClasses())

readJSON(file, verbose = FALSE)

parseJSON(json, verbose = FALSE)

processCX(aspectList, verbose = FALSE, aspectClasses = getAspectClasses())
}
\arguments{
\item{file}{character; the name of the file which the data are to be read from}

\item{verbose}{logical; whether to print what is happening}

\item{aspectClasses}{named character; accession names and aspect classes \link{aspectClasses}}

\item{json}{character; raw JSON data}

\item{aspectList}{list; list containing the aspect data (parsed JSON)}
}
\value{
\link[=RCX-object]{RCX} object
}
\description{
The \code{readCX} function combines three sub-task:
\itemize{
\item read the JSON from file
\item parse the JSON
\item process the contained aspects to create an \link[=RCX-object]{RCX} object
}
}
\details{
If any errors occur during this process, the single steps can be performed individually.
This also allows to skip certain steps, for example if the JSON data is already availabe as text,
there is no need to save it as file and read it again.
\subsection{Read the JSON from file}{

The \code{readJSON} function only read the content of a text file and returns it as a simple character vector.
}

\subsection{Parse the JSON}{

The \code{parseJSON} function uses the \link[jsonlite:fromJSON]{jsonlite} package, to parse JSON text:

\code{jsonlite::fromJSON(cx, simplifyVector = FALSE)}

The result is a list containing the aspect data as elements.
If, for some reason, the JSON is not valid, the \link[jsonlite:fromJSON]{jsonlite} package raises an error.
}

\subsection{Process the contained aspects to create an \link[=RCX-object]{RCX} object}{

With the \code{processCX} function, the single elements from the previous list will be processed with the \link{jsonToRCX} functions,
which creating objects for the single aspects.
The standard CX aspects are processed by generic functions named by the aspect names of the CX data structure, e.g.
\code{jsonToRCX.nodeAttributes} for the samely named CX aspect the corresponding \code{NodeAttributesAspect} in \link[=RCX-object]{RCX}
(see also \code{vignette("02. The RCX and CX Data Model")} or NDEx documentation: \url{https://home.ndexbio.org/data-model/}).

The CX network may contain additional aspects besides the officially defined ones.
This includes self defined or deprecated aspects, that sill can be found in the networks at the NDEx platform.
By default, those aspects are simply omitted.
In those cases, the setting \emph{verbose} to \code{TRUE} is a good idea to see, which aspects cannot be processed this package.

Those not processable aspects can be handled individually, but it is advisable to extend the \link{jsonToRCX} functions by
implementing own versions for those aspects.
Additionally, the \strong{update} functions have to be implemented to add the newly generated aspect objects
to \link[=RCX-object]{RCX} object (see e.g. \link{updateNodes} or \link{updateEdges}).
Therefore, the function also have to be named \verb{"update<aspect-name>}, where aspect-name is the capitalized version of the
name used in the CX.
(see also \code{vignette("03. Extending the RCX Data Model")}
}
}
\section{Functions}{
\itemize{
\item \code{readJSON()}: Reads the CX/JSON from file and returns the content as text

\item \code{parseJSON()}: Parses the JSON text and returns a list with the aspect data

\item \code{processCX()}: Processes the list of aspect data and creates an \link[=RCX-object]{RCX}

}}
\examples{
cxFile = system.file(
  "extdata", 
  "Imatinib-Inhibition-of-BCR-ABL-66a902f5-2022-11e9-bb6a-0ac135e8bacf.cx", 
  package = "RCX"
)

rcx = readCX(cxFile)

## OR:

json = readJSON(cxFile)
aspectList = parseJSON(json)
rcx = processCX(aspectList)
}
\seealso{
\link{jsonToRCX}, \link{writeCX}
}
