% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphNEL.R
\name{graphNEL}
\alias{graphNEL}
\alias{toGraphNEL}
\alias{fromGraphNEL}
\title{Convert an RCX object from and to an graphNEL object}
\usage{
toGraphNEL(rcx, directed = FALSE)

fromGraphNEL(
  graphNEL,
  nodeId = "id",
  nodeName = "nodeName",
  nodeIgnore = c("name"),
  edgeId = "id",
  edgeInteraction = "edgeInteraction",
  edgeIgnore = c(),
  suppressWarning = FALSE
)
}
\arguments{
\item{rcx}{\link[=RCX-object]{RCX} object}

\item{directed}{logical; whether the graph is directed}

\item{graphNEL}{\link[graph:graphNEL-class]{graphNEL} object}

\item{nodeId}{character; igraph attribute name used for \link[=Nodes]{node} ids}

\item{nodeName}{character; igraph attribute name used for \link[=Nodes]{node} names}

\item{nodeIgnore}{character; igraph attribute names that should be ignored}

\item{edgeId}{character; igraph attribute name used for \link[=Edges]{edge} ids}

\item{edgeInteraction}{character; igraph attribute name used for \link[=Edges]{edge} interaction}

\item{edgeIgnore}{character; igraph attribute names that should be ignored}

\item{suppressWarning}{logical; whether to suppress a warning message, if the validation of the \link[=RCX-object]{RCX} object fails}
}
\value{
\link[graph:graphNEL-class]{graphNEL} or \link[=RCX-object]{RCX} object
}
\description{
Convert an \link[=RCX-object]{RCX} object to an \link[graph:graphNEL-class]{graphNEL} object
}
\details{
In the \link[graph:graphNEL-class]{graphNEL} object the attributes are not separated from the graph like in \link[=RCX-object]{RCX}.
Therefore, for converting an \link[=RCX-object]{RCX} object to an \link[graph:graphNEL-class]{graphNEL} object, and back,
some adjustments in the naming of the attributes have to be made.

For nodes the \code{name} can be present in the \link[=Nodes]{nodes} aspect, as name in the \link[=NodeAttributes]{nodeAttributes} aspect.
Also \code{name} is used in \link[graph:graphNEL-class]{graphNEL} for naming the vertices.
To avoid collisions in the conversion, the \link[=Nodes]{nodes} name is saved in \link[graph:graphNEL-class]{graphNEL} as \code{nodeName},
while the \link[=NodeAttributes]{nodeAttributes} property \code{name} is saved as \code{"attribute...name"}.
These names are also used for the conversion back to \link[=RCX-object]{RCX}, but here the \code{name} used in the
\link[=Nodes]{nodes} aspect can be changed by the \code{nodeName} parameter.

Similar to the node name, if \code{"represents"} is present as property in \link[=NodeAttributes]{nodeAttributes} its name is changed to
\code{"attribute...represents"}.

The conversion of \link[=Edges]{edges} works analogously:
If \code{"interaction"} is present as property in \link[=EdgeAttributes]{edgeAttributes} its name is changed to \code{"attribute...interaction"}.

\link{Nodes} and \link[=Edges]{edges} must have IDs in the \link[=RCX-object]{RCX}, but not in the \link[graph:graphNEL-class]{graphNEL} object.
To define an \link[graph:nodeData-methods]{vertex} or \link[graph:edgeData-methods]{edge} attribute to be used as ID, the parameters
\code{nodeId} and \code{edgeId} can be used to define ether an attribute name (default:"id") or set it to \code{NULL} to generate ID automatically.

The attributes also may have a special data type assigned.
The data type then is saved by adding \code{"...dataType"} to the attribute name.

The \link[=CartesianLayout]{cartesian layout} is also stored in the \link[graph:graphNEL-class]{graphNEL} object.
To make those \link[graph:nodeData-methods]{graph vertex attributes} distinguishable from \link[=NodeAttributes]{nodeAttributes}
they are named \code{"cartesianLayout...x"}, \code{"cartesianLayout...y"} and \code{"cartesianLayout...z"}.

In the \link[=RCX-object]{RCX} attributes it is also possible to define a \link[=CySubNetworks]{subnetwork}, to which an attribute applies.
Those attributes are added with \code{"...123"} added to its name, where \code{"123"} is the \link[=CySubNetworks]{subnetwork id}.
The \link[=CySubNetworks]{subnetwork id} itself are added as graph graph attributes, and are named
\verb{subnetwork...123...nodes"} and \code{"subnetwork...123...edges"}, where \code{"123"} is the \link[=CySubNetworks]{subnetwork id}.

Altogether, the conventions look as follows:
\code{"[attribute...]<name>[...<subnetwork>][...dataType]"}
}
\examples{
## Read from a CX file
## reading the provided example network of the package
cxFile <- system.file(
 "extdata", 
 "Imatinib-Inhibition-of-BCR-ABL-66a902f5-2022-11e9-bb6a-0ac135e8bacf.cx", 
 package = "RCX"
)

rcx = readCX(cxFile)

## graphNEL can handle multi-edges, but only if the graph is directed and the 
## source and target start and end not between the same nodes.
## Unfortunaltelly this is the case in our sample network.
## A quick fix is simply switching the direction of source and target 
## for the multi-edges:
dubEdges = duplicated(rcx$edges[c("source","target")])

s = rcx$edges$source
rcx$edges$source[dubEdges] = rcx$edges$target[dubEdges]
rcx$edges$target[dubEdges] = s[dubEdges]

## convert the network to graphNEL
gNel = toGraphNEL(rcx, directed = TRUE)

## convert it back
rcxFromGraphNel = fromGraphNEL(gNel)
}
\seealso{
\link{Igraph}, \code{\link[igraph:as_graphnel]{igraph::as_graphnel()}}
}
