% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-CartesianLayout.R
\name{updateCartesianLayout}
\alias{updateCartesianLayout}
\alias{updateCartesianLayout.CartesianLayoutAspect}
\alias{updateCartesianLayout.RCX}
\title{Update Cartesian Layouts}
\usage{
updateCartesianLayout(
  x,
  cartesianLayout,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateCartesianLayout}{CartesianLayoutAspect}(
  x,
  cartesianLayout,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateCartesianLayout}{RCX}(
  x,
  cartesianLayout,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  checkReferences = TRUE,
  ...
)
}
\arguments{
\item{x}{\link[=RCX-object]{RCX} or \code{\link{CartesianLayout}} object; (to which the new layout will be added)}

\item{cartesianLayout}{\code{\link{CartesianLayout}} object; (the layout, that will be added)}

\item{replace}{logical; if existing values are updated (or ignored)}

\item{stopOnDuplicates}{logical; whether to stop, if duplicates in \code{nodes} (and \code{view} if present) column are found}

\item{...}{additional parameters}

\item{checkReferences}{logical; whether to check if references to other aspects are present in the \link[=RCX-object]{RCX} object}
}
\value{
\emph{CartesianLayoutAspect} or \link[=RCX-object]{RCX} object with added layout
}
\description{
This functions add a cartesian layout in the form of a \code{\link{CartesianLayout}} object to an other \code{\link{CartesianLayout}}
or an \link[=RCX-object]{RCX} object.
}
\details{
Networks, or more precisely its nodes may have a cartesian layout, that is represented as \code{\link{CartesianLayout}} object.
\code{\link{CartesianLayout}} objects can be added to an \link[=RCX-object]{RCX} or an other \code{\link{CartesianLayout}} object.

In the case, that a \code{\link{CartesianLayout}} object is added to an other, or the \link[=RCX-object]{RCX} object already contains a
\code{\link{CartesianLayout}} object, some attributes might be present in both. By default, the properties are updated with the values
of the latest one. This can prevented by setting the \emph{replace} parameter to \code{FALSE}, in that case only new properties are added and
the existing properties remain untouched.

Furthermore, if duplicated properties are considered as a preventable mistake, an error can be raised by setting \emph{stopOnDuplicates}
to \code{TRUE}. This forces the function to stop and raise an error, if duplicated properties are present.
}
\examples{
## For CartesianLayoutAspects: 
## prepare some aspects:
cartesianLayout = createCartesianLayout(
  node=c(0, 1),
  x=c(5.5, 110.1), 
  y=c(200.3, 210.2),
  z=c(-1, 3.1),
)

## node 0 is updated, new view is added 
cartesianLayout2 = createCartesianLayout(
  node=c(0, 0),
  x=c(5.7, 7.2), 
  y=c(98, 13.9),
  view=c(NA, 1476)
)

## Simply update with new values
cartesianLayout3 = updateCartesianLayout(cartesianLayout, cartesianLayout2)

## Ignore already present keys
cartesianLayout3 = updateCartesianLayout(cartesianLayout, cartesianLayout2, 
                                         replace=FALSE)

## Raise an error if duplicate keys are present
try(updateCartesianLayout(cartesianLayout, cartesianLayout2, 
                          stopOnDuplicates=TRUE))
## =>ERROR: 
## Provided IDs (node, view) countain duplicates!

## For RCX:
## prepare RCX object:
nodes = createNodes(name = c("a","b"))
edges = createEdges(source = 0, target = 1)
cySubNetworks = createCySubNetworks(
  id = 1476,
  nodes = "all",
  edges = "all"                    
)
rcx = createRCX(nodes,
                edges = edges,
                cySubNetworks=cySubNetworks)

## add the network attributes
rcx = updateCartesianLayout(rcx, cartesianLayout)

## add additional network attributes and update existing
rcx = updateCartesianLayout(rcx, cartesianLayout2)
}
