% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Json-toJson.R
\name{rcxToJson}
\alias{rcxToJson}
\alias{rcxToJson.default}
\alias{rcxToJson.MetaDataAspect}
\alias{rcxToJson.NodesAspect}
\alias{rcxToJson.EdgesAspect}
\alias{rcxToJson.NodeAttributesAspect}
\alias{rcxToJson.EdgeAttributesAspect}
\alias{rcxToJson.NetworkAttributesAspect}
\alias{rcxToJson.CartesianLayoutAspect}
\alias{rcxToJson.CyGroupsAspect}
\alias{rcxToJson.CyHiddenAttributesAspect}
\alias{rcxToJson.CyNetworkRelationsAspect}
\alias{rcxToJson.CySubNetworksAspect}
\alias{rcxToJson.CyTableColumnAspect}
\alias{rcxToJson.CyVisualPropertiesAspect}
\alias{rcxToJson.CyVisualProperty}
\alias{rcxToJson.CyVisualPropertyProperties}
\alias{rcxToJson.CyVisualPropertyDependencies}
\alias{rcxToJson.CyVisualPropertyMappings}
\title{Convert RCX aspects to JSON}
\usage{
rcxToJson(aspect, verbose = FALSE, ...)

\method{rcxToJson}{default}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{MetaDataAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{NodesAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{EdgesAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{NodeAttributesAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{EdgeAttributesAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{NetworkAttributesAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{CartesianLayoutAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{CyGroupsAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{CyHiddenAttributesAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{CyNetworkRelationsAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{CySubNetworksAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{CyTableColumnAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{CyVisualPropertiesAspect}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{CyVisualProperty}(aspect, verbose = FALSE, propertyOf = "", ...)

\method{rcxToJson}{CyVisualPropertyProperties}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{CyVisualPropertyDependencies}(aspect, verbose = FALSE, ...)

\method{rcxToJson}{CyVisualPropertyMappings}(aspect, verbose = FALSE, ...)
}
\arguments{
\item{aspect}{aspects of an \link[=RCX-object]{RCX} object}

\item{verbose}{logical; whether to print what is happening}

\item{...}{additional parameters, that might needed for extending}

\item{propertyOf}{character; provide propertyOf (only necessary for \link{CyVisualProperty})}
}
\value{
character; JSON of an aspect
}
\description{
Functions for converting the different aspects to JSON following the CX data structure definition
(see NDEx documentation: \url{https://home.ndexbio.org/data-model/}).
}
\details{
For converting \link[=RCX-object]{RCX} objects to JSON, each aspect is processed by a generic function for its
aspect class. Those functions return a character only containing the JSON of this aspect, which is then
combined by \link{toCX} to be a valid CX data structure.

To support the conversion for non-standard or own-defined aspects, generic functions for those aspect classes
have to be implemented.
}
\examples{
nodes = createNodes(name = c("a","b","c","d","e","f"))
rcxToJson(nodes)
}
\seealso{
\link{toCX}, \link{writeCX}, \link{jsonToRCX}, \link{readCX}
}
