% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-json.R
\name{convert-data-types-and-values}
\alias{convert-data-types-and-values}
\alias{.convertDataTypes}
\alias{.convertValues}
\title{Convert data types in \code{data.frame(dataType,isList)} to character of NDEx data types}
\usage{
.convertDataTypes(df, cols = c(dataType = "dataType", isList = "isList"))

.convertValues(df, cols = c(value = "value", isList = "isList"))
}
\arguments{
\item{df}{data.frame with dataType and isList: \code{data.frame(dataType,isList)}}

\item{cols}{named character; column names of dataType and isList in df}
}
\value{
character; NDEx data types (e.g. "string" or "list_of_integer")
}
\description{
Convert data types in \code{data.frame(dataType,isList)} to character of NDEx data types
}
\note{
Internal function only for convenience
}
\examples{
df = data.frame(dataType=c("string","boolean","double","integer","long",
                           "string","boolean","double","integer","long"),
                isList=c(FALSE,FALSE,FALSE,FALSE,FALSE,
                         TRUE,TRUE,TRUE,TRUE,TRUE))
df$value = list("string",TRUE,3.14,314,314,
                c("str","ing"),c(TRUE,FALSE),c(3.14,1.0),c(314,666),c(314,666))
RCX:::.convertDataTypes(df)
RCX:::.convertValues(df)
}
\keyword{internal}
