% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-TableColumns.R
\name{CyTableColumn}
\alias{CyTableColumn}
\alias{createCyTableColumn}
\title{Cytoscape table column properties}
\usage{
createCyTableColumn(
  appliesTo,
  name,
  dataType = NULL,
  isList = NULL,
  subnetworkId = NULL
)
}
\arguments{
\item{appliesTo}{character; indicates whether this applies to "nodes", "edges" or "networks" table columns}

\item{name}{character; key of the attribute}

\item{dataType}{character (optional); data type of the attribute}

\item{isList}{logical (optional); a value should be considered as list}

\item{subnetworkId}{integer (optional); reference to \link[=CySubNetworks]{subnetwork id}, but left blank (or \code{NA}) if root-network}
}
\value{
\emph{CyTableColumnAspect} object
}
\description{
This function is used to create Cytoscape table column aspects.
}
\details{
Cytoscape contributes aspects that organize subnetworks, attribute tables, and visual attributes for use by its own layout and
analysis tools. Furthermore are the aspects used in web-based visualizations like within the NDEx platform.

These elements are used to represent Cytoscape table column labels and types. Its main use is to disambiguate empty table columns.
The same attribute can also be defined for different \link[=CySubNetworks]{subnetworks} with different values.
Cytoscape does not currently support table columns for the root network, but this is option is included here for consistency.

With \emph{isList} it can be set, if a value should be considered as a list. This is of minor significance while working solely with
\link[=RCX-object]{RCX} objects, unless it will be transformed to JSON.
}
\examples{
## a minimal example
tableColumn = createCyTableColumn(
  appliesTo="nodes",
  name="weight"
)

## defining several properties at once
tableColumn = createCyTableColumn(
  appliesTo=c("nodes","edges"),
  name=c("weight","weight")
)

## with all parameters
tableColumn = createCyTableColumn(
  appliesTo=c("nodes","edges","networks"),
  name=c("weight","weight","collapsed"),
  dataType=c("numeric","numeric","logical"),
  isList=c(FALSE,FALSE,TRUE),
  subnetworkId=c(NA,NA,1)
)
}
\seealso{
\code{\link{updateCyTableColumn}}; \code{\link{CyNetworkRelations}}
}
