% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{PlotPseudoTime}
\alias{PlotPseudoTime}
\title{Infer the pseudo-temporal ordering between the cell types using the
distance from a cell type to the predefined starting cell type.}
\usage{
PlotPseudoTime(
  S,
  TrueLabel,
  startPoint,
  fontSize = 12,
  dataName = "",
  sim = TRUE
)
}
\arguments{
\item{S}{the similarity matrix calculated by SimS() function}

\item{TrueLabel}{the real cell types used to indicate the vertical axis}

\item{startPoint}{the posiition of the starting cell in the matrix}

\item{fontSize}{the font size of the plot}

\item{dataName}{the name of the data that will be showed in the plot}

\item{sim}{indicate the input data is simialrity matrix or not}
}
\value{
PstudoTime

PseudoTimePlot  ggplot object of the pseudo-temporal ordering of cells
}
\description{
Infer the pseudo-temporal ordering between the cell types using the
distance from a cell type to the predefined starting cell type.
}
\examples{
gfData <- GenesFilter(yan)
TrueLabel <- ann$cell_type1
res_SimS <- SimS(gfData)
PlotPseudoTime(res_SimS$S,TrueLabel,startPoint=1)

}
