% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_plot.RCM.R
\name{plot.RCM}
\alias{plot.RCM}
\title{Plot RC(M) ordination result with the help of ggplot2}
\usage{
\method{plot}{RCM}(
  x,
  ...,
  Dim = c(1, 2),
  plotType = c("samples", "species", "variables"),
  samColour = if (is.null(inflVar)) NULL else "Influence",
  taxNum = if (all(plotType == "species") || !is.null(taxRegExp)) {
     ncol(x$X)
 }
    else {
     10
 },
  taxRegExp = NULL,
  varNum = 15,
  arrowSize = 0.25,
  inflDim = 1,
  inflVar = NULL,
  returnCoords = FALSE,
  alpha = TRUE,
  varPlot = NULL,
  colLegend = if (!is.null(inflVar)) paste0("Influence on\\n", inflVar,
    "\\nparameter \\nin dimension", inflDim) else samColour,
  samShape = NULL,
  shapeLegend = samShape,
  samSize = 2,
  scalingFactor = NULL,
  quadDrop = 0.995,
  plotEllipse = TRUE,
  taxaScale = 0.5,
  Palette = if (!all(plotType == "species")) "Set1" else "Paired",
  taxLabels = !all(plotType == "species"),
  taxDots = FALSE,
  taxCol = "blue",
  taxColSingle = "blue",
  nudge_y = 0.08,
  axesFixed = TRUE,
  aspRatio = 1,
  xInd = if (all(plotType == "samples")) c(0, 0) else c(-0.75, 0.75),
  yInd = c(0, 0),
  taxLabSize = 4,
  varLabSize = 3.5,
  alphaRange = c(0.2, 1),
  varExpFactor = 10,
  manExpFactorTaxa = 0.975,
  nPhyl = 10,
  phylOther = c(""),
  legendSize = samSize,
  noLegend = is.null(samColour),
  crossSize = 4,
  contCol = c("orange", "darkgreen"),
  legendLabSize = 15,
  legendTitleSize = 16,
  axisLabSize = 14,
  axisTitleSize = 16,
  plotPsi = "psi",
  breakChar = "\\n"
)
}
\arguments{
\item{x}{an RCM object}

\item{...}{further arguments, passed on to aes in the the ggplot() function}

\item{Dim}{An integer vector of length two, which dimensions to plot}

\item{plotType}{a character string: which components to plot.
Can be any combination of 'samples','species' and 'variables'}

\item{samColour}{a character string, the variable to use for the colour
of the sample dots. Can also be a richness measure, or "influence". Alternatively,
a vector equal to the number of samples in the RCM object can be supplied. See details.}

\item{taxNum}{an integer, the number of taxa to be plotted}

\item{taxRegExp}{a character vector indicating which taxa to plot.
Any taxa matcing this regular expression will be plotted}

\item{varNum}{an integehr, number of variable arrows to draw}

\item{arrowSize}{a scalar, the size of the arrows}

\item{inflDim}{an integer, the dimension for which the influence
should be calculated}

\item{inflVar}{the variable on which the influence should be plotted. See details.}

\item{returnCoords}{a boolean, should final coordinates be returned?}

\item{alpha}{a boolean, should small arrows be made transparent?}

\item{varPlot}{the names of the variable arrows to plot.
Overrides the varNum argument}

\item{colLegend}{a character string, the legend text for the sample colour.
Defaults to the name of the colour variable}

\item{samShape}{a character string, the variable to use for the shape
of the sample dots}

\item{shapeLegend}{a character string, the text to use for the shapeLegend.
Defaults to the name of the shape variable}

\item{samSize}{a scalar, the size of the sample dots}

\item{scalingFactor}{a scalar, a user supplied scaling factor
for the taxon arrows. If not supplied it will be calculated to make sample
 and taxon plots on the same scale}

\item{quadDrop}{a number between 0 and 1. At this fraction of the peak height
are the ellipses of the quadratic response functions drawn}

\item{plotEllipse}{a boolean, whether to add the ellipses}

\item{taxaScale}{a scalar, by which to scale the rectangles
of the quadratic taxon plot}

\item{Palette}{the colour palette}

\item{taxLabels}{a boolean, should taxon labels be plotted?}

\item{taxDots}{a boolean, should taxa be plotted as dots?}

\item{taxCol}{the taxon colour}

\item{taxColSingle}{the taxon colour if there is only one}

\item{nudge_y}{a scalar, the offet for the taxon labels}

\item{axesFixed}{A boolean, should the aspect ratio of the plot
(the scale between the x and y-axis) be fixed.
It is highly recommended to keep this argument at TRUE
for honest representation of the ordination. If set to FALSE,
the plotting space will be optimally used but the plot
 may be deformed in the process.}

\item{aspRatio}{The aspect ratio of the plot when 'axesfixed' is TRUE
(otherwise this argument is ignored), passde on to ggplot2::coord_fixed().
It is highly recommended to keep this argument at 1 for honest
 representation of the ordination.}

\item{xInd}{a scalar or a vector of length 2, specifying the indentation
left and right of the plot to allow for the labels to be printed entirely.
 Defaults to 0.75 at every side}

\item{yInd}{a scalar or a vector of length 2, specifying the indentation
top and bottom of the plot to allow for the labels to be printed entirely.
 Defaults to 0 at every side}

\item{taxLabSize}{the size of taxon labels}

\item{varLabSize}{the size of the variable label}

\item{alphaRange}{The range of transparency}

\item{varExpFactor}{a scalar, the factor by which to expand
the variable coordinates}

\item{manExpFactorTaxa}{a manual expansion factor for the taxa.
Setting it to a high value allows you to plot the taxa around the samples}

\item{nPhyl}{an integer, number of phylogenetic levels to show}

\item{phylOther}{a character vector of phylogenetic levels
to be included in the 'other' group}

\item{legendSize}{a size for the coloured dots in the legend}

\item{noLegend}{a boolean indicating you do not want a legend}

\item{crossSize}{the size of the central cross}

\item{contCol}{a character vector of length two, giving the low
and high values of the continuous colour scale}

\item{legendLabSize}{size of the legend labels}

\item{legendTitleSize}{size of the legend title}

\item{axisLabSize}{size of the axis labels}

\item{axisTitleSize}{size of the axis title}

\item{plotPsi}{a character vector, describing what to plot on the axis.
Can be either 'psi', 'none' or 'loglik'.
The latter plots the log-likelihood explained}

\item{breakChar}{a character string indicating how the taxon names
should be broken}
}
\value{
plots a ggplot2-object to output
}
\description{
Plot RC(M) ordination result with the help of ggplot2
}
\details{
This function relies on the ggplot2 machinery to produce the plots,
and the result can be modified accordingly. Monoplots,
biplots and for constrained analysis even triplots can be produced,
depending on the 'plotType' argument.

When one of either 'Observed', 'Chao1', 'ACE', 'Shannon', 'Simpson',
'InvSimpson' or 'Fisher' are supplied to the 'samColour' argument,
the according richness measure (as calculated by phyloseq::estimate_richness)
 is mapped to the sample colour. When "influence" is supplied, the influence
 on the variable supplied is plotted. This 'inflVar' variable should be
 either "psi", or a variable name.
}
\note{
Supplying only few categorical variables as constraining variables may
cause the samples to be plotted on top of each other, since the number of
unique sample scores is limited. The plot is still valid, but consider adding
more sample variables to spread out the samples
}
\examples{
data(Zeller)
require(phyloseq)
tmpPhy = prune_taxa(taxa_names(Zeller)[1:100],
prune_samples(sample_names(Zeller)[1:50], Zeller))
# Subset for a quick fit
zellerRCM = RCM(tmpPhy)
plot(zellerRCM)
}
\seealso{
\code{\link{RCM}},\code{\link{addOrthProjection}},
\code{\link{extractCoord}},\code{\link{plotRespFun}}
}
