% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_estDisp.R
\name{estDisp}
\alias{estDisp}
\title{Estimate the overdispersion}
\usage{
estDisp(
  X,
  cMat = NULL,
  rMat = NULL,
  muMarg,
  psis,
  trended.dispersion = NULL,
  prior.df = 10,
  dispWeights = NULL,
  rowMat = NULL,
  allowMissingness = FALSE,
  naId
)
}
\arguments{
\item{X}{the data matrix of dimensions nxp}

\item{cMat}{a 1xp colum scores matrix}

\item{rMat}{a nx1 rowscores matrix, if unconstrained}

\item{muMarg}{an nxp offset matrix}

\item{psis}{a scalar, the current psi estimate}

\item{trended.dispersion}{a vector of length p with pre-calculated
trended.dispersion estimates. They do not vary in function
of the offset anyway}

\item{prior.df}{an integer, number of degrees of freedom of the prior
for the Bayesian shrinkage}

\item{dispWeights}{Weights for estimating the dispersion
in a zero-inflated model}

\item{rowMat}{matrix of row scores in case of constrained ordination}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X}
}
\value{
A vector of length p with dispersion estimates
}
\description{
Estimate the overdispersion
}
\details{
Information between taxa is shared with empirical Bayes
 using the edgeR pacakage, where the time-limiting steps are programmed in C.
}
