% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_analysis.R
\name{getMotifSummaryTable}
\alias{getMotifSummaryTable}
\title{getMotifSummaryTable}
\usage{
getMotifSummaryTable(motifResults)
}
\arguments{
\item{motifResults}{Output object of \code{runMotifDiscovery} function}
}
\value{
A data.frame object containing summary statistics about the
  discovered motifs
}
\description{
Get summary stats for top discovered motifs
}
\examples{

data(queryRegions)
motifResults <- runMotifDiscovery(queryRegions = queryRegions[1:1000],
                                  genomeVersion = 'hg19',
                                  resize = 15,
                                  motifN = 1,
                                  maxMismatch = 1,
                                  nCores = 2)
motifSummary <- getMotifSummaryTable(motifResults)
}
