% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_functions.R
\name{calculateCoverageProfile}
\alias{calculateCoverageProfile}
\title{calculateCoverageProfile}
\usage{
calculateCoverageProfile(
  queryRegions,
  targetRegions,
  sampleN = 0,
  bin.num = 100,
  bin.op = "mean",
  strand.aware = TRUE
)
}
\arguments{
\item{queryRegions}{GRanges object imported from a BED file using 
\code{importBed} function}

\item{targetRegions}{GRanges object containing genomic coordinates of a 
target feature (e.g. exons)}

\item{sampleN}{If set to a positive integer, \code{targetRegions} will be 
downsampled to \code{sampleN} regions}

\item{bin.num}{Positive integer value (default: 100) to determine how many
bins the targetRegions should be split into (See
genomation::ScoreMatrixBin)}

\item{bin.op}{The operation to apply for each bin: 'min', 'max', or 'mean'
(default: mean). (See genomation::ScoreMatrixBin)}

\item{strand.aware}{TRUE/FALSE (default: TRUE) The strands of target regions
are considered.}
}
\value{
A ScoreMatrix object returned by \code{genomation::ScoreMatrixBin} 
  function. Target regions are divided into 100 equal sized bins and coverage
  level is calculated in a strand-specific manner.
}
\description{
This function checks overlaps between input query regions and annotation 
features, and then calculates coverage profile along target regions.
}
\examples{
data(gff)
data(queryRegions)
txdbFeatures <- getTxdbFeaturesFromGRanges(gffData = gff)
df <- calculateCoverageProfile(queryRegions = queryRegions,
                              targetRegions = txdbFeatures$exons,
                                    sampleN = 1000)
}
