% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_internal.R
\encoding{UTF-8}
\name{validatecreateAUROCGraph}
\alias{validatecreateAUROCGraph}
\title{Validate input parameters for createAccuracyGraph
function}
\usage{
validatecreateAUROCGraph(dfAUROC, title, selectD, selectColor)
}
\arguments{
\item{dfAUROC}{a \code{data.frame} corresponding to res$paraSample$dfAUROC
where res is the result of inferAncestry() or inferAncestryGeneAware()
functions.}

\item{title}{a \code{character} string representing the title of the graph.}

\item{selectD}{a \code{array} of \code{integer} representing the selected
PCA dimensions to plot. The length of the \code{array} cannot be more than
5 entries. The dimensions must tested by RAIDS (i.e. be present in the
RDS file).}

\item{selectColor}{a \code{array} of \code{character} strings representing
the selected colors for the associated PCA dimensions to plot. The length
of the \code{array} must correspond to the length of the \code{selectD}
parameter. In addition, the length of the \code{array} cannot be more than
5 entries.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates the parameters for the
\code{\link{createAccuracyGraph}} function.
}
\examples{

## Path to RDS file with ancestry information generated by RAIDS (demo file)
dataDir <- system.file("extdata", package="RAIDS")
fileRDS <- file.path(dataDir, "TEST_01.infoCall.RDS")
info <- readRDS(fileRDS)
dfAUROC <- info$paraSample$dfAUROC

## Some of the column names must be updated to fit new standards
colnames(dfAUROC) <- c("D", "K", "Call", "L", "AUROC", "H")

## Validate parameters
RAIDS:::validatecreateAUROCGraph(dfAUROC=dfAUROC, title="Accuracy Graph", 
    selectD=c(6, 12), selectColor=c("blue","darkblue"))
    
}
\author{
Astrid Deschênes and Pascal Belleau
}
\keyword{internal}
