% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateRunExomeOrRNAAncestry}
\alias{validateRunExomeOrRNAAncestry}
\title{Validate the parameters of the runExomeAncestry() function}
\usage{
validateRunExomeOrRNAAncestry(
  pedStudy,
  studyDF,
  pathProfileGDS,
  pathGeno,
  pathOut,
  fileReferenceGDS,
  fileReferenceAnnotGDS,
  chrInfo,
  syntheticRefDF,
  genoSource,
  verbose
)
}
\arguments{
\item{pedStudy}{a \code{data.frame} with those mandatory columns: "Name.ID",
"Case.ID", "Sample.Type", "Diagnosis", "Source". All columns must be in
\code{character} strings (no factor). The \code{data.frame}
must contain the information for all the samples passed in the
\code{listSamples} parameter. Only \code{filePedRDS} or \code{pedStudy}
can be defined.}

\item{studyDF}{a \code{data.frame} containing the information about the
study associated to the analysed sample(s). The \code{data.frame} must have
those 3 columns: "study.id", "study.desc", "study.platform". All columns
must be in \code{character} strings (no factor).}

\item{pathProfileGDS}{a \code{character} string representing the path to
the directory where the GDS Profile files will be created.
Default: \code{NULL}.}

\item{pathGeno}{a \code{character} string representing the path to the
directory containing the VCF output of SNP-pileup for each sample. The
SNP-pileup files must be compressed (gz files) and have the name identifiers
of the samples. A sample with "Name.ID" identifier would have an
associated SNP-pileup file called "Name.ID.txt.gz". The directory must
exist.}

\item{pathOut}{a \code{character} string representing the path to
the directory where the output files are created.}

\item{fileReferenceGDS}{a \code{character} string representing the file
name of the Population Reference GDS file. The file must exist.}

\item{fileReferenceAnnotGDS}{a \code{character} string representing the
file name of the Population Reference GDS annotation file.
The file must exist.}

\item{chrInfo}{a \code{vector} of positive \code{integer} values
representing the length of the chromosomes. See 'details' section.}

\item{syntheticRefDF}{a \code{data.frame} containing those columns:
\describe{
\item{sample.id}{ a \code{character} string representing the sample
identifier. }
\item{pop.group}{ a \code{character} string representing the
subcontinental population assigned to the sample. }
\item{superPop}{ a \code{character} string representing the
super-population assigned to the sample. }
}}

\item{verbose}{a \code{logical} indicating if messages should be printed
to show how the different steps in the function. Default: \code{FALSE}.}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function validates the input parameters for the
\code{\link{runExomeAncestry}} function. When a parameter is not as
expected, an error message is generated.
}
\examples{

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## Path where the output file will be generated
pathOut <- file.path(dataDir, "example", "res.out")

## Study data frame
study <- data.frame(study.id = "MYDATA",
                      study.desc = "Description",
                      study.platform = "PLATFORM",
                      stringsAsFactors = FALSE)

## Population Reference GDS demo file
gdsRef <- file.path(dataDir, "PopulationReferenceDemo.gds")

gdsAnnotRef <- file.path(dataDir, "PopulationReferenceSNVAnnotationDemo.gds")

## Pedigree Study data frame
ped <- data.frame(Name.ID=c("Sample_01", "Sample_02"),
            Case.ID=c("TCGA-H01", "TCGA-H02"),
            Sample.Type=c("DNA", "DNA"),
            Diagnosis=c("Cancer", "Cancer"), Source=c("TCGA", "TCGA"))

## Required library for this example to run correctly
if (requireNamespace("Seqinfo", quietly=TRUE) &&
     requireNamespace("BSgenome.Hsapiens.UCSC.hg38", quietly=TRUE)) {

    ## Chromosome length information
    ## chr23 is chrX, chr24 is chrY and chrM is 25
    chrInfo <- Seqinfo::seqlengths(BSgenome.Hsapiens.UCSC.hg38::Hsapiens)[1:25]

    ## Profiles used for synthetic data set
    syntheticRefDF <- data.frame(sample.id=c("HG00150", "HG00138", "HG00330",
        "HG00275"), pop.group=c("GBR", "GBR","FIN", "FIN"),
        superPop=c("EUR", "EUR", "EUR", "EUR"), stringsAsFactors=FALSE)

    ## Returns OL when all parameters are valid
    RAIDS:::validateRunExomeOrRNAAncestry(pedStudy=ped, studyDF=study,
        pathProfileGDS=dataDir, pathGeno=dataDir, pathOut=pathOut,
        fileReferenceGDS=gdsRef, fileReferenceAnnotGDS=gdsAnnotRef,
        chrInfo=chrInfo, syntheticRefDF=syntheticRefDF,
        genoSource="snp-pileup", verbose=FALSE)

}

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
