% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateProfileGDSExist}
\alias{validateProfileGDSExist}
\title{Validate that the Profile GDS file exists for the specified profile}
\usage{
validateProfileGDSExist(pathProfile, profile)
}
\arguments{
\item{pathProfile}{a \code{character} string representing the directory
where the Profile GDS files will be created. The directory must exist.}

\item{profile}{a \code{character} string
corresponding to the profile identifier. A Profile GDS file
corresponding to the profile identifier must exist and be located in the
\code{pathProfile} directory.}
}
\value{
a \code{character} string representing the path to the existing
Profile GDS file.
}
\description{
The function validates that the Profile GDS file associated
to a profile identifier exists in the specified directory.
}
\examples{

## Path to the demo 1KG GDS file is located in this package
dataDir <- system.file("extdata/tests", package="RAIDS")

## The function returns the path to the existing Profile GDS file
RAIDS:::validateProfileGDSExist(pathProfile=dataDir,
    profile="ex1_demo")

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
