% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateAdd1KG2SampleGDS}
\alias{validateAdd1KG2SampleGDS}
\title{Validate input parameters for add1KG2SampleGDS() function}
\usage{
validateAdd1KG2SampleGDS(gdsReference, gdsProfileFile, currentProfile, studyID)
}
\arguments{
\item{gdsReference}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened Population Reference
GDS file.}

\item{gdsProfileFile}{a \code{character} string representing the path and
file name of the Profile GDS file. The Profile GDS file must exist.}

\item{currentProfile}{a \code{character} string corresponding to the profile
identifier associated to the current list of pruned SNVs.}

\item{studyID}{a \code{character} string corresponding to the study
identifier associated to the current list of pruned SNVs.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link{add1KG2SampleGDS}} function.
}
\examples{

## Required library
library(gdsfmt)

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## The 1KG Population Reference GDS demo file (opened)
gds1KG <- openfn.gds(file.path(dataDir,
                "PopulationReferenceDemo.gds"), readonly=TRUE)

## The validatiion should be successful
RAIDS:::validateAdd1KG2SampleGDS(gdsReference=gds1KG,
    gdsProfileFile=file.path(dataDir, "GDS_Sample_with_study_demo.gds"),
    currentProfile="Sample01", studyID="Synthetic")

## All GDS file must be closed
closefn.gds(gdsfile=gds1KG)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
