% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\encoding{UTF-8}
\name{snvListVCF}
\alias{snvListVCF}
\title{Generate a VCF with the information from the SNPs that pass
a cut-off threshold}
\usage{
snvListVCF(gdsReference, fileOut, offset = 0L, freqCutoff = NULL)
}
\arguments{
\item{gdsReference}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the 1KG GDS file.}

\item{fileOut}{a \code{character} string representing the path and file
name of the VCF file that will be created wit the retained SNP information.
The file should have the ".vcf" extension.}

\item{offset}{a single \code{integer} that is added to the SNP position to
switch from 0-based to 1-based coordinate when needed (or reverse).
Default: \code{0L}.}

\item{freqCutoff}{a single positive \code{numeric} specifying the cut-off to
keep a SNP. If \code{NULL}, all SNPs are retained. Default: \code{NULL}.}
}
\value{
The integer \code{0L} when successful.
}
\description{
This function extract the SNPs that pass a frequency cut-off
in at least one super population
from a GDS SNP information file and save the retained SNP information into
a VCF file.
}
\examples{

## Required library
library(gdsfmt)

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## Demo 1KG Reference GDS file
fileGDS <- openfn.gds(file.path(dataDir,
                    "PopulationReferenceDemo.gds"))

## Output VCF file that will be created (temporary)
vcfFile <- file.path(tempdir(), "Demo_TMP_01.vcf")

## Create a VCF file with the SNV dataset present in the GDS file
## No cutoff on frequency, so all SNVs are saved
snvListVCF(gdsReference=fileGDS, fileOut=vcfFile, offset=0L,
                    freqCutoff=NULL)

## Close GDS file (IMPORTANT)
closefn.gds(fileGDS)

## Remove temporary VCF file
unlink(vcfFile, force=TRUE)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
