% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{runLDPruning}
\alias{runLDPruning}
\title{SNP pruning based on linkage disequilibrium (LD)}
\usage{
runLDPruning(
  gds,
  method,
  listSamples = NULL,
  listKeep = NULL,
  slideWindowMaxBP = 500000L,
  thresholdLD = sqrt(0.1),
  np = 1L,
  verbose
)
}
\arguments{
\item{gds}{an \code{object} of class
\code{\link[SNPRelate]{SNPGDSFileClass}}, a SNP GDS file.}

\item{method}{a \code{character} string that represents the method that will
be used to calculate the linkage disequilibrium in the
\code{\link[SNPRelate]{snpgdsLDpruning}}() function. The 4 possible values
are: "corr", "r", "dprime" and "composite".}

\item{listSamples}{a \code{vector} of \code{character} strings
corresponding to the sample identifiers used in LD pruning done by the
\code{\link[SNPRelate]{snpgdsLDpruning}}() function. If \code{NULL}, all
samples are used. Default: \code{NULL}.}

\item{listKeep}{a \code{vector} of SNVs identifiers specifying selected;
if \code{NULL}, all SNVs are used in the
\code{\link[SNPRelate]{snpgdsLDpruning}} function. Default: \code{NULL}.}

\item{slideWindowMaxBP}{a single positive \code{integer} that represents
the maximum basepairs (bp) in the sliding window. This parameter is used
for the LD pruning done in the \code{\link[SNPRelate]{snpgdsLDpruning}}()
function.
Default: \code{500000L}.}

\item{thresholdLD}{a single \code{numeric} value that represents the LD
threshold used in the \code{\link[SNPRelate]{snpgdsLDpruning}} function.
Default: \code{sqrt(0.1)}.}

\item{np}{a single positive \code{integer} specifying the number of
threads to be used. Default: \code{1L}.}

\item{verbose}{a \code{logical} indicating if information is shown during
the process in the \code{\link[SNPRelate]{snpgdsLDpruning}}() function.}
}
\value{
a \code{list} of SNP identifiers stratified by chromosomes as
generated by \code{\link[SNPRelate]{snpgdsLDpruning}} function.
}
\description{
This function is a wrapper for the
\code{\link[SNPRelate]{snpgdsLDpruning}}() function that generates a pruned
subset of SNPs that are in approximate linkage equilibrium.
}
\details{
The SNP pruning is based on linkage disequilibrium (LD) and is done by the
\code{\link[SNPRelate]{snpgdsLDpruning}}() function in the
SNPRelate package (https://bioconductor.org/packages/SNPRelate/).
}
\examples{

## Required
library(SNPRelate)

## Open an example dataset (HapMap)
genoFile <- snpgdsOpen(snpgdsExampleFileName())

## Fix seed to get reproducible results
set.seed(1000)

## Get linkage Disequilibrium (LD) based SNP pruning
snpSet <- RAIDS:::runLDPruning(gds=genoFile, verbose=FALSE)
names(snpSet)

## Get SNP ids
snp.id <- unlist(unname(snpSet))

## Close the genotype file
snpgdsClose(genoFile)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
