% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelicFraction_internal.R
\encoding{UTF-8}
\name{getTableSNV}
\alias{getTableSNV}
\title{Extract the genotype information for a SNV dataset using
the Profile GDS file and the Reference GDS file}
\usage{
getTableSNV(
  gdsReference,
  gdsSample,
  currentProfile,
  studyID,
  minCov = 10,
  minProb = 0.999,
  eProb = 0.001,
  verbose
)
}
\arguments{
\item{gdsReference}{an object of class \code{\link[gdsfmt]{gds.class}} (a
GDS file), the opened Reference GDS file.}

\item{gdsSample}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the opened Profile GDS file.}

\item{currentProfile}{a \code{character} string corresponding to
the sample identifier used in \code{\link{pruningSample}} function.}

\item{studyID}{a \code{character} string corresponding to the study
identifier used in \code{\link{pruningSample}} function.}

\item{minCov}{a single positive \code{integer} representing the minimum
required coverage. Default: \code{10L}.}

\item{minProb}{a single \code{numeric} between \code{0} and \code{1}
representing the probability that the calculated genotype call is correct.
Default: \code{0.999}.}

\item{eProb}{a single \code{numeric} between \code{0} and \code{1}
representing the probability of sequencing error. Default: \code{0.001}.}

\item{verbose}{a \code{logicial} indicating if messages should be printed
when the function is running.}
}
\value{
a \code{data.frame} containing:
\describe{
\item{cnt.tot}{ a single \code{integer} representing the total coverage for
the SNV.}
\item{cnt.ref}{ a single \code{integer} representing the coverage for
the reference allele.}
\item{cnt.alt}{ a single \code{integer} representing the coverage for
the alternative allele.}
\item{snpPos}{ a single \code{integer} representing the SNV position.}
\item{snp.chr}{ a single \code{integer} representing the SNV chromosome.}
\item{normal.geno}{ a single \code{numeric} indicating the genotype of the
SNV. The possibles are: \code{0} (wild-type homozygote), \code{1}
(heterozygote), \code{2} (altenative homozygote), \code{3} indicating that
the normal genotype is unknown.}
\item{pruned}{ a \code{logical}}
\item{snp.index}{ a \code{vector} of \code{integer} representing the
position of the SNVs in the Reference GDS file.}
\item{keep}{ a \code{logical} }
\item{hetero}{ a \code{logical} }
\item{homo}{ a \code{logical} }
}
}
\description{
The function generates a \code{data.frame} containing the
genotype information from a initial list of SNVs associated to a specific
profile. The function uses the information present in the Reference GDS file
and the Profile GDS file.
}
\examples{

## Required library
library(gdsfmt)

## Path to the demo 1KG GDS file is located in this package
dataDir <- system.file("extdata/tests", package="RAIDS")
fileGDS <- file.path(dataDir, "ex1_good_small_1KG.gds")

## Temporary Profile GDS file for one profile in temporary directory
fileProfile <- file.path(tempdir(), "ex1.gds")

## Copy the Profile GDS file demo that has been pruned and annotated
file.copy(file.path(dataDir, "ex1_demo_with_pruning_and_1KG_annot.gds"),
                 fileProfile)

## Open the reference GDS file (demo version)
gds1KG <- snpgdsOpen(fileGDS)

## Open Profile GDS file for one profile
profileGDS <- openfn.gds(fileProfile)

## The function returns a data frame containing the SNVs information
result <- RAIDS:::getTableSNV(gdsReference=gds1KG, gdsSample=profileGDS,
        currentProfile="ex1", studyID="MYDATA", minCov=10L, minProb=0.999,
        eProb=0.001, verbose=FALSE)
head(result)

## Close both GDS files (important)
closefn.gds(profileGDS)
closefn.gds(gds1KG)

## Remove Profile GDS file (created for demo purpose)
unlink(fileProfile, force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
