% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetic_internal.R
\encoding{UTF-8}
\name{computeSyntheticConfMat}
\alias{computeSyntheticConfMat}
\title{Calculate the confusion matrix of the inferences for specific
values of D and K using the inferred ancestry results from the synthetic
profiles.}
\usage{
computeSyntheticConfMat(
  matKNN,
  matKNNAncestryColumn,
  pedCall,
  pedCallAncestryColumn,
  listCall
)
}
\arguments{
\item{matKNN}{a \code{data.frame} containing the inferred ancestry results
for fixed values of \emph{D} and \emph{K}. The \code{data.frame} must contained
those columns: "sample.id", "D", "K" and the fourth column name must
correspond to the \code{matKNNAncestryColumn} argument.}

\item{matKNNAncestryColumn}{a \code{character} string representing the
name of the column that contains the inferred ancestry for the specified
synthetic profiles. The column must be present in the \code{matKNN}
argument.}

\item{pedCall}{a \code{data.frame} containing the information about
the super-population information from the 1KG GDS file
for profiles used to generate the synthetic profiles. The \code{data.frame}
must contained a column named as the \code{pedCallAncestryColumn} argument.}

\item{pedCallAncestryColumn}{a \code{character} string representing the
name of the column that contains the known ancestry for the reference
profiles in the Reference GDS file. The column must be present in
the \code{pedCall} argument.}

\item{listCall}{a \code{vector} of \code{character} strings representing
the list of possible ancestry assignations.}
}
\value{
\code{list} containing 2 entries:
\describe{
\item{confMat}{ a \code{matrix} representing the confusion matrix }
\item{matAccuracy}{ a \code{data.frame} containing the statistics
associated to the confusion matrix}
}
}
\description{
The function calculates the confusion matrix of the inferences
for fixed values of \emph{D} and \emph{K} using the inferred ancestry results done
on the synthetic profiles.
}
\examples{

## Loading demo dataset containing pedigree information for synthetic
## profiles and known ancestry of the profiles used to generate the
## synthetic profiles
data(pedSynthetic)

## Loading demo dataset containing the inferred ancestry results
## for the synthetic data
data(matKNNSynthetic)

## The inferred ancestry results for the synthetic data using
## values of D=6 and K=5
matKNN <- matKNNSynthetic[matKNNSynthetic$K == 6 & matKNNSynthetic$D == 5, ]

## Compile the confusion matrix using the
## synthetic profiles for fixed values of  D and K values
results <- RAIDS:::computeSyntheticConfMat(matKNN=matKNN,
    matKNNAncestryColumn="SuperPop",
    pedCall=pedSynthetic, pedCallAncestryColumn="superPop",
    listCall=c("EAS", "EUR", "AFR", "AMR", "SAS"))

results$confMat
results$matAccuracy


}
\author{
Pascal Belleau, Astrid Deschênes and Alex Krasnitz
}
\keyword{internal}
