% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy.R
\encoding{UTF-8}
\name{computePCAMultiSynthetic}
\alias{computePCAMultiSynthetic}
\title{Project synthetic profiles onto existing principal component axes
generated using the reference 1KG profiles}
\usage{
computePCAMultiSynthetic(
  gdsProfile,
  listPCA,
  sampleRef,
  studyIDSyn,
  verbose = FALSE
)
}
\arguments{
\item{gdsProfile}{an object of class \link[gdsfmt]{gds.class} (a GDS file),
an opened Profile GDS file.}

\item{listPCA}{a \code{list} containing the PCA \code{object} generated
with the 1KG reference profiles (excluding the ones used to generate the
synthetic data set) in an entry called \code{"pca.unrel"}.}

\item{sampleRef}{a \code{vector} of \code{character} strings representing
the identifiers of the 1KG reference profiles that have been used to
generate the synthetic profiles
that are going to be analysed here. The sub-continental
identifiers are used as names for the \code{vector}.}

\item{studyIDSyn}{a \code{character} string corresponding to the study
identifier.
The study identifier must be present in the Profile GDS file.}

\item{verbose}{a \code{logical} indicating if messages should be printed
to show how the different steps in the function. Default: \code{FALSE}.}
}
\value{
a \code{list} containing 3 entries:
\describe{
\item{sample.id}{ a \code{vector} of \code{character} strings representing
the identifiers of the synthetic profiles that have been projected onto
the 1KG PCA. }
\item{eigenvector.ref}{ a \code{matrix} of \code{numeric} with the
eigenvectors of the 1KG reference profiles used to generate the PCA.}
\item{eigenvector}{ a \code{matrix} of \code{numeric} with the
eigenvectors of the synthetic profiles projected onto the 1KG PCA. }
}
}
\description{
The function projects  the synthetic profiles onto existing
principal component axes generated using the reference 1KG profiles. The
reference profiles used to generate the synthetic profiles have previously
been removed from the set of reference profiles.
}
\examples{

## Required library
library(gdsfmt)

## Loading demo PCA on subset of 1KG reference dataset
data(demoPCA1KG)

## Path to the demo Profile GDS file is located in this package
dataDir <- system.file("extdata/demoKNNSynthetic", package="RAIDS")

# The name of the synthetic study
studyID <- "MYDATA.Synthetic"

samplesRM <- c("HG00246", "HG00325", "HG00611", "HG01173", "HG02165",
    "HG01112", "HG01615", "HG01968", "HG02658", "HG01850", "HG02013",
    "HG02465", "HG02974", "HG03814", "HG03445", "HG03689", "HG03789",
    "NA12751", "NA19107", "NA18548", "NA19075", "NA19475", "NA19712",
    "NA19731", "NA20528", "NA20908")
names(samplesRM) <- c("GBR", "FIN", "CHS","PUR", "CDX", "CLM", "IBS",
    "PEL", "PJL", "KHV", "ACB", "GWD", "ESN", "BEB", "MSL", "STU", "ITU",
    "CEU", "YRI", "CHB", "JPT", "LWK", "ASW", "MXL", "TSI", "GIH")

## Open the Profile GDS file
gdsProfile <- snpgdsOpen(file.path(dataDir, "ex1.gds"))

## Projects synthetic profiles on 1KG PCA
results <- computePCAMultiSynthetic(gdsProfile=gdsProfile,
    listPCA=demoPCA1KG,
    sampleRef=samplesRM, studyIDSyn=studyID, verbose=FALSE)

## The eigenvectors for the synthetic profiles
head(results$eigenvector)

## Close Profile GDS file (important)
closefn.gds(gdsProfile)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
