% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QFeatures-longForm.R
\name{longForm,QFeatures-method}
\alias{longForm,QFeatures-method}
\alias{longForm}
\alias{longForm,QFeatures}
\alias{longFormat}
\alias{longForm,SummarizedExperiment-method}
\alias{longForm,SummarizedExperiment}
\title{Reshape into a long data format}
\usage{
\S4method{longForm}{QFeatures}(object, colvars = NULL, rowvars = NULL, i = 1L)

\S4method{longForm}{SummarizedExperiment}(object, colvars = NULL, rowvars = NULL, i = seq_along(assays(object)))
}
\arguments{
\item{object}{An instance of class \link{QFeatures} or \link{SummarizedExperiment}.}

\item{colvars}{A \code{character()} that selects column(s) in the \code{colData}.}

\item{rowvars}{A \code{character()} with the names of the \code{rowData}
variables (columns) to retain in any assay.}

\item{i}{When \code{object} is an instance of class \code{QFeatures}, a \code{numeric(1)}
indicating what assay within each \code{SummarizedExperiment} object to
return. Default is \code{1L}. If \code{object} is a \code{SummarizedExperiment}, a
\code{numeric()} indicating what assays to pull and convert. Default is to
use all assays.}
}
\value{
A \code{DataFrame} instance.
}
\description{
The \code{longForm()} method transform a \link{QFeatures} or \link{SummarizedExperiment}
instance into a long \emph{tidy} \link{DataFrame} that contains the assay data, where
each quantitative value is reported on a separate line. \code{colData} and
\code{rowData} varibales can also be added. This function is an extension of the
\code{longForm()} method in the \link[MultiAssayExperiment:MultiAssayExperiment]{MultiAssayExperiment::MultiAssayExperiment}.

Note that the previous \code{longFormat} implementation is not defunct.
}
\examples{

data(feat2)

longForm(feat2)

## add a colData variable and use it in longFrom
colData(feat2)$colvar <- paste0("Var", 1:12)
colData(feat2)
longForm(feat2, colvars = "colvar")

## use a rowData variable in longFrom
rowDataNames(feat2)
longForm(feat2, rowvar = "Prot")

## use both col/rowData
longForm(feat2, colvar = "colvar", rowvar = "Prot")

## also works on a single SE
se <- getWithColData(feat2, 1)
longForm(se)
longForm(se, colvar = "colvar")
longForm(se, rowvar = "Prot")
longForm(se, colvar = "colvar", rowvar = "Prot")
}
