% Generated by roxygen2 (4.0.0): do not edit by hand
\name{plot_inter}
\alias{plot_inter}
\title{Plot frequency of response for each group}
\usage{
plot_inter(restab, sequence = NULL, from = 0, to = max(restab$position),
  ...)
}
\arguments{
\item{restab}{A \code{data.frame}. The result of a peptide microarray
analysis, as returned by \code{pepStat}'s \code{restab} function.}

\item{sequence}{A \code{character} or an \code{AAString}. If not NULL, the
sequence of the \code{ProteinSequenceTrack} to plot. It should be the
sequence of the reference genome used in the \code{peptideSet} that
generated the \code{restab}.}

\item{from}{A \code{numeric}, the start coordinate of the plot.}

\item{to}{A \code{numeric}, the end coordinate of the plot.}

\item{...}{Aditional arguments to be passed to \code{plotTracks}.}
}
\description{
Plot an axis and the frequency of response of each group, averaged by peptides
at each position.
}
\examples{
if(require(pepDat)){
  data(restab_aggregate)
  plot_inter(restab_aggregate)
}
}
\author{
Renan Sauteraud
}
\seealso{
\code{restab}, \code{plot_clade}, \code{\link{plotTracks}}
}

