% Generated by roxygen2 (4.0.0): do not edit by hand
\docType{class}
\name{ProteinSequenceTrack}
\alias{ProteinSequenceTrack}
\alias{ProteinSequenceTrack-class}
\title{ProteinSequenceTrack}
\usage{
ProteinSequenceTrack(sequence = NULL, name = "Sequence", ...)
}
\arguments{
\item{sequence}{A \code{character} or \code{AAString} of length one. The
sequence to display.}

\item{name}{A \code{character}. The name of the track used in the title panel
when plotting}

\item{...}{Additional items which will all be interpreted as display
  parameters.}
}
\description{
A track to display peptides and protein sequences.
}
\examples{
if(require(pepDat)){
  data(pep_hxb2)
  hxb2_seq <- metadata(pep_hxb2)$sequence
  st<-ProteinSequenceTrack(sequence=hxb2_seq, name="env")

  # Plotting amino acids
  plotTracks(st, to = 20)

  # When the range becomes wider, only coloured squares are displayed
  plotTracks(st, to = 100)

  # When overplotting, a single line will mark the ProteinSequenceTrack
  plotTracks(st)
}
}
\author{
Renan Sauteraud
}
\seealso{
\code{\link{SequenceTrack}}, \code{\link{DisplayPars}}
}

