% Generated by roxygen2 (4.0.0): do not edit by hand
\docType{class}
\name{ProbeTrack}
\alias{ProbeTrack}
\alias{ProbeTrack-class}
\title{ProbeTrack}
\usage{
ProbeTrack(sequence, intensity, probeStart, restab = NULL, group = NULL,
  name = "ProbeTrack", ...)
}
\arguments{
\item{sequence}{A \code{character} vector. The sequence of peptides to
display.}

\item{intensity}{A \code{numeric} vector. The frequency of binding or the
baseline corrected intensity for the peptides.}

\item{probeStart}{A \code{numeric} vector. The start position of the peptides.}

\item{name}{A \code{character}. The name of the track used in the title panel
when plotting}

\item{restab}{A \code{data.frame} containing all the above parameters, as
outputted by \code{pepStat}'s \code{restab} function.}

\item{group}{A \code{character}. The group to display on the \code{ProbeTrak}.
  This is only required when \code{restab} is not NULL. See details section
  for more information.}

\item{...}{Arguments to be passed to
\code{DataTrack}.}
}
\description{
This track can be used to display the frequency of antibody binding for each
probe on an arrayas predicted by \code{pepStat}'s function \code{makeCalls}.
}
\details{
The vectors for the arguments \code{sequence}, \code{freq} and
\code{probeStart} should be of the same length. If \code{restab} is provided,
the three previous arguments will be ignored and \code{group} must be
specified. \code{group} must be a valid column name in \code{restab},
\code{data.frame}.
}
\section{Slots}{

\describe{
\item{\code{sequence}}{A \code{character} vector. The probes sequence.}

\item{\code{probeStart}}{A \code{numeric} vector. The start position of the probes.}

\item{\code{intensity}}{A \code{numeric} vector. The frequency of response of each probe.
 Or the baseline corrected intensity of the signal.}
}}
\examples{
if(require(pepDat)){
  data(restab)
  pt <- ProbeTrack(sequence = restab$peptide,
                   intensity = restab$group2,
                   probeStart = restab$start)
  plotTracks(pt)
  plotTracks(pt, from = 460, to = 560, legend=TRUE)
}
}
\author{
Renan Sauteraud
}
\seealso{
\code{\link{GdObject}}

\code{restab}
}

