% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ProteoDiscography-class}
\alias{ProteoDiscography-class}
\title{ProteoDiscography}
\description{
An S4 object containing the reference genome sequences and gene-model annotations (TxDB).

This also stores genomic variants and splice-junctions from which mutant transcript sequences can be generated.
}
\section{Slots}{

\describe{
\item{\code{TxDb}}{(\link[GenomicFeatures]{TxDb}): TxDb object containing the genomic and transcript annotations.}

\item{\code{genomeSeqs}}{(\link[Biostrings]{DNAStringSet} or \link[BSgenome]{BSgenome}): Genomic sequence of the respective genome.}

\item{\code{input.genomicVariants}}{(\link[VariantAnnotation]{VRangesList}): Imported genomic variants (SNV, MNV and InDels).}

\item{\code{input.spliceJunctions}}{(DataFrame): Imported splice-junctions.}

\item{\code{input.manualSequences}}{(DataFrame): Imported manual sequences.}

\item{\code{mutantTranscripts.genomicVariants}}{(\link[tibble]{tibble}): Generated mutant mRNA sequences from genomic variants.}

\item{\code{mutantTranscripts.spliceJunctions}}{(\link[tibble]{tibble}): Generated mutant mRNA sequences from splice-junctions.}

\item{\code{mutantTranscripts.manualSequences}}{(\link[tibble]{tibble}): Processed mutant mRNA sequences from manual input.}

\item{\code{GENETIC_CODE}}{(\link[Biostrings]{GENETIC_CODE_TABLE}): The genetic code table to be used during translation.}

\item{\code{metadata}}{(data.frame): Supplied data.frame.}
}}

\author{
Job van Riet
}
