% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_aic.R
\name{aic}
\alias{aic}
\alias{gaussian_aic}
\alias{gaussian_aicc}
\alias{gaussian_bic}
\title{Model selection for Gaussian mixture models}
\usage{
gaussian_aic(coefs, chromatogram)

gaussian_aicc(coefs, chromatogram)

gaussian_bic(coefs, chromatogram)
}
\arguments{
\item{coefs}{the coefficients of the Gaussian mixture model, output by 
\code{\link{fit_gaussians}}}

\item{chromatogram}{the raw elution profile}
}
\value{
the AIC, corrected AIC, or BIC of the fit model
}
\description{
Calculate the AIC, corrected AIC, or BIC for a curve fit with a Gaussian 
mixture model by nonlinear least squares optimization. This function 
permits the calculation of the AIC/AICc/BIC after rejecting some Gaussians
in the model, for example because their centres are outside the bounds of 
the profile.
}
