% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polytect_clust.R
\name{polytect_clust}
\alias{polytect_clust}
\title{Main function for clustering}
\usage{
polytect_clust(
  data,
  cluster_num,
  fp_par = "default",
  fp_optim = c(0.1, 1, 1.5),
  lambdas = rep(2, 64 - log2(64)),
  coefs = rep(1, 6)
)
}
\arguments{
\item{data}{A matrix of fluorescence intensities in each channel. Each row represents each partitions, and each column each channel.}

\item{cluster_num}{The expected maximum number of clusters.}

\item{fp_par}{The parameters for flowPeaks. \code{fp_par}=c("default","manual","auto"). When "default" is chosen, the default parameters of
flowPeaks will be used. With "manual", you have to fill in \code{fp_optim}.}

\item{fp_optim}{The paramters for flowPeaks that users have to fill in manually when \code{fp_par} is set at "manual".}

\item{lambdas}{The penalty terms for the deviation from the expected cluster centers. Higher \code{lambdas} penalizes the deviation more.}

\item{coefs}{The coefficients to adjust for the expected cluster centers. The default is 1 which can be used for common assay designs and has
to be modified for special assays such as competing assays.}
}
\value{
A data frame containing the original fluorescence intensity and the cluster labels.
}
\description{
This is the main function for clustering. The function will start with flowPeaks, then merge the excess clusters. It will
return a data frame of fluorescence intensities and partition labels.
}
\examples{
data(HR)
head(polytect_clust(HR, 4))
}
