% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatTestUnpaired.R
\name{limma_unpaired}
\alias{limma_unpaired}
\title{Perform unpaired limma analysis}
\usage{
limma_unpaired(Data, NumCond, NumReps, RRCateg)
}
\arguments{
\item{Data}{A matrix of quantitative expression data.}

\item{NumCond}{The number of conditions in the experiment.}

\item{NumReps}{The number of replicates per condition.}

\item{RRCateg}{A matrix specifying the conditons to be compared
(each comparison given as separate column).}
}
\value{
A list containing the following results:
\itemize{
\item plvalues: The p-values from limma tests.
\item qlvalues: The q-values from limma tests.
\item Sds: The standard deviations of the Bayesian linear model.
@details This function performs unpaired limma analysis on Data. It
calculates the p-values and q-values for each row, indicating the
significance of the difference between the two datasets.RRCateg is a
matrix specifying the conditons to be compared (each comparison given
as separate column). It thus has always 2 rows and n columns, where n
is the number of comparisons. The function returns a list containing
the p-values and q-values for each comparison, as well as the standard
deviations of the Bayesian linear model.
}
}
\description{
This function performs unpaired limma analysis on Data.
}
\examples{
dataMatrix <- matrix(rnorm(900), ncol = 9)
NumCond <- 3
NumReps <- 3
colnames(dataMatrix) <- rep(c("A", "B", "C"), each = 3)
#  Specifying comparisons
RRCateg <- matrix(c(1, 2, 2, 3), nrow = 2, ncol = 2)
# Run function
results <- limma_unpaired(dataMatrix, NumCond, NumReps, RRCateg)
print(results$plvalues)

}
\keyword{analysis}
\keyword{limma}
\keyword{unpaired}
