% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/podcallPlots.R
\name{podcallChannelPlot}
\alias{podcallChannelPlot}
\title{podcallChannelPlot}
\usage{
podcallChannelPlot(channelData, thr, channel, plotId = NULL)
}
\arguments{
\item{channelData}{Amplitude values from one channel of a well.}

\item{thr}{The threshold set for \code{channel} of a well.}

\item{channel}{The channel the amplitude values belong to. Target channel is
1, control channel is 2.}

\item{plotId}{A character string with title for the plot.}
}
\value{
A gtable with scatterplot and histogram
}
\description{
Function that calls podcallScatterplot and podcallHistogram and
    draws a plot with both scatter plot and histogram.
}
\examples{
## Get path to data
path <- system.file("extdata", "Amplitudes/", package="PoDCall")

## Read in data
data <- importAmplitudeData(path, skipLines=0)
data("thrTable")

## Get name of first list element and use as well ID
well_id <- names(data)[1]

## Set channel to plot
channel <- 1

## Get threshold for well_id and channel 1 (see ?thrTable)
thr <- thrTable[well_id, "thr_target"]

podcallChannelPlot(channelData=data[[well_id]][[channel]], thr, channel)

}
