% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeDistribution.R
\name{createPercentageDistributionData}
\alias{createPercentageDistributionData}
\title{Create data for percentage present taxa distribution}
\usage{
createPercentageDistributionData(inputData = NULL, rankName = NULL,
    taxDB = NULL)
}
\arguments{
\item{inputData}{dataframe contains raw input data in long format
(see ?mainLongRaw)}

\item{rankName}{name of the working taxonomy rank (e.g. "species", "family")}

\item{taxDB}{Path to the taxonomy DB files}
}
\value{
A dataframe for analysing the distribution of the percentage of
species in the selected supertaxa, containing the seed protein IDs,
percentage of their orthologs in each supertaxon and the corresponding
supertaxon names.
}
\description{
Create data for percentage present taxa distribution
}
\examples{
data("mainLongRaw", package="PhyloProfile")
createPercentageDistributionData(mainLongRaw, "class")
}
\seealso{
\code{\link{mainLongRaw}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
