% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsePhyloProfile.R
\name{calcPresSpec}
\alias{calcPresSpec}
\title{Calculate percentage of present species in each super taxon}
\usage{
calcPresSpec(profileWithTax, taxaCount)
}
\arguments{
\item{profileWithTax}{data frame of main PhyloProfile input together
with their taxonomy info (see ?profileWithTaxonomy)}

\item{taxaCount}{number of species occur in each supertaxon (e.g. phylum
or kingdom)}
}
\value{
A data frame with % of present species in each supertaxon
}
\description{
Calculate percentage of present species in each super taxon
}
\examples{
# NOTE: for internal testing only
library(dplyr)
data("profileWithTaxonomy", package="PhyloProfile")
taxaCount <- profileWithTaxonomy \%>\% dplyr::count(supertaxon)
taxaCount$n <- 1
calcPresSpec(profileWithTaxonomy, taxaCount)
}
\seealso{
\code{\link{profileWithTaxonomy}} for a demo input data
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
