% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSynergy.R
\name{fitTwowayZIP}
\alias{fitTwowayZIP}
\title{Two-way fitting for projected dose-response curve.}
\usage{
fitTwowayZIP(
  combo_profiles,
  residual = "logcosh",
  show_Rsqr = TRUE,
  nthread = 1L,
  optim_only = TRUE,
  loss_args = list()
)
}
\arguments{
\item{combo_profiles}{\link{data.table} contains three parameters of dose-response curves
for each single agent in a drug comnbination,
and the observed viability of two treatments combined.}

\item{residual}{\code{character} Method used to minimise residual in fitting curves.
3 methods available: \code{c("logcosh", "normal", "Cauchy")}.
The default method is \code{logcosh}.
It minimises the logarithmic hyperbolic cosine loss of the residuals
and provides the fastest estimation among the three methods,
with fitting quality in between \code{normal} and \code{Cauchy};
recommanded when fitting large-scale datasets.
The other two methods minimise residuals by
considering the truncated probability distribution (as in their names) for the residual.
\code{Cauchy} provides the best fitting quality but also takes the longest to run.}

\item{show_Rsqr}{\code{logical} whether to show goodness-of-fit value in the result.}

\item{nthread}{\code{integer} Number of cores used to perform computation. Default 1.}

\item{optim_only}{\code{logical(1)} Should the fall back methods when optim fails}

\item{loss_args}{\code{list} Additional argument to the \code{loss} function.
These get passed to losss via \code{do.call} analagously to using \code{...}.}
}
\value{
\link{data.table} contains parameters of projected dose-response curves
for adding one treatment to the other.
}
\description{
Fit projected dose-response curves with \code{E_min} as the viability
of the treatment being added to the other treament at a fixed dose.
}
\examples{
\dontrun{
combo_profiles <- CoreGx::buildComboProfiles(tre, c("HS", "EC50", "E_inf", "viability"))
combo_twowayFit <- fitTwowayZIP(combo_profiles)
}

}
\references{
Yadav, B., Wennerberg, K., Aittokallio, T., & Tang, J. (2015). Searching for Drug Synergy in Complex Dose–Response Landscapes Using an Interaction Potency Model. Computational and Structural Biotechnology Journal, 13, 504–513. https://doi.org/10.1016/j.csbj.2015.09.001
}
