% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSynergy.R
\name{.computeZIPdelta}
\alias{.computeZIPdelta}
\title{Vector-based version of \link{computeZIPdelta}}
\usage{
.computeZIPdelta(
  treatment1id,
  treatment2id,
  treatment1dose,
  treatment2dose,
  sampleid,
  HS_1,
  HS_2,
  EC50_1,
  EC50_2,
  E_inf_1,
  E_inf_2,
  combo_viability,
  ZIP = NULL,
  residual = "logcosh",
  nthread = 1L,
  show_Rsqr = FALSE
)
}
\arguments{
\item{treatment1id}{\code{character} a vector of identifiers for treatment 1}

\item{treatment2id}{\code{character} a vector of identifiers for treatment 2}

\item{treatment1dose}{\code{numeric} a vector of concentrations for treatment 1}

\item{treatment2dose}{\code{numeric} a vector of concentrations for treatment 2}

\item{sampleid}{\code{character} Cell-line ID of a drug combination screening experiment.}

\item{HS_1}{\code{numeric} Hill coefficient of treatment 1}

\item{HS_2}{\code{numeric} Hill coefficient of treatment 2}

\item{EC50_1}{\code{numeric} relative EC50 of treatment 1.}

\item{EC50_2}{\code{numeric} relative EC50 of treatment 2.}

\item{E_inf_1}{\code{numeric} viability produced by the maximum attainable effect of treatment 1.}

\item{E_inf_2}{\code{numeric} viability produced by the maximum attainable effect of treatment 2.}

\item{combo_viability}{\code{numeric} observed viability of the two treatments combined.}

\item{ZIP}{\code{numeric} pre-computed ZIP reference values.
If not provided, it will be computed during delta score calculation.}

\item{residual}{\code{character} Method used to minimise residual in fitting curves.
3 methods available: \code{c("logcosh", "normal", "Cauchy")}.
The default method is \code{logcosh}.
It minimises the logarithmic hyperbolic cosine loss of the residuals
and provides the fastest estimation among the three methods,
with fitting quality in between \code{normal} and \code{Cauchy};
recommanded when fitting large-scale datasets.
The other two methods minimise residuals by
considering the truncated probability distribution (as in their names) for the residual.
\code{Cauchy} provides the best fitting quality but also takes the longest to run.}

\item{nthread}{\code{integer} Number of cores used to perform computation.
Default 1.}

\item{show_Rsqr}{\code{logical} Whether to show the 2-way curve fitting quality in the result.
Default FALSE.}
}
\value{
\code{numeric} delta scores of every dose combinations for any given treatment combinations.
}
\description{
Following the calculation of ZIP delta score as in Appendix A3.
See reference for details.
}
\examples{
\dontrun{
## ZIP is optional. Will be recomputed if not provided.
combo_profiles <- CoreGx::buildComboProfiles(
     tre, 
     c("HS", "EC50", "E_inf", "ZIP", "combo_viability"))
combo_profiles[,
        .computeZIPdelta(
            treatment1id = treatment1id,
            treatment2id = treatment2id,
            treatment1dose = treatment1dose,
            treatment2dose = treatment2dose,
            sampleid = sampleid,
            HS_1 = HS_1, HS_2 = HS_2,
            EC50_1 = EC50_1, EC50_2 = EC50_2,
            E_inf_1 = E_inf_1, E_inf_2 = E_inf_2,
            combo_viability = combo_viability,
            ZIP = ZIP,
            nthread = 4,
            show_Rsqr = TRUE
        )
    ] -> delta_scores
}

}
\references{
Yadav, B., Wennerberg, K., Aittokallio, T., & Tang, J. (2015). Searching for Drug Synergy in Complex Dose–Response Landscapes Using an Interaction Potency Model. Computational and Structural Biotechnology Journal, 13, 504–513. https://doi.org/10.1016/j.csbj.2015.09.001
}
\keyword{internal}
