% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSynergy.R
\docType{methods}
\name{computeZIPdelta,TreatmentResponseExperiment-method}
\alias{computeZIPdelta,TreatmentResponseExperiment-method}
\title{Compute ZIP delta score}
\usage{
\S4method{computeZIPdelta}{TreatmentResponseExperiment}(object, residual = "logcosh", nthread = 1L, show_Rsqr = FALSE)
}
\arguments{
\item{object}{\link{TreatmentResponseExperiment}
The \code{TreatmentResponseExperiment} from which to extract assays
\code{mono_profile} and \code{combo_viability} to compute ZIP delta scores.}

\item{residual}{\code{character} Method used to minimise residual in fitting curves.
3 methods available: \code{c("logcosh", "normal", "Cauchy")}.
The default method is \code{logcosh}.
It minimises the logarithmic hyperbolic cosine loss of the residuals
and provides the fastest estimation among the three methods,
with fitting quality in between \code{normal} and \code{Cauchy};
recommanded when fitting large-scale datasets.
The other two methods minimise residuals by
considering the truncated probability distribution (as in their names) for the residual.
\code{Cauchy} provides the best fitting quality but also takes the longest to run.}

\item{nthread}{\code{integer} Number of cores used to perform computation.
Default 1.}

\item{show_Rsqr}{\code{logical} Whether to show the 2-way curve fitting quality in the result.
Default FALSE.}
}
\value{
\link{TreatmentResponseExperiment} with assay \code{combo_scores} containing \code{delta_scores}
}
\description{
Following the calculation of ZIP delta score as in Appendix A3.
See reference for details.

Compute ZIP delta score as described in the original paper.
}
\examples{
\dontrun{
tre <- computeZIPdelta(tre, residual = "Cauchy", nthread = 2L)
}

}
\references{
Yadav, B., Wennerberg, K., Aittokallio, T., & Tang, J. (2015). Searching for Drug Synergy in Complex Dose–Response Landscapes Using an Interaction Potency Model. Computational and Structural Biotechnology Journal, 13, 504–513. https://doi.org/10.1016/j.csbj.2015.09.001
}
