% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeIC50.R, R/computeICn.R
\name{computeIC50}
\alias{computeIC50}
\alias{computeICn}
\title{Computes the ICn for any n in 0-100 for a Drug Dose Viability Curve}
\usage{
computeIC50(
  concentration,
  viability,
  Hill_fit,
  conc_as_log = FALSE,
  viability_as_pct = TRUE,
  verbose = TRUE,
  trunc = TRUE
)

computeICn(
  concentration,
  viability,
  Hill_fit,
  n,
  conc_as_log = FALSE,
  viability_as_pct = TRUE,
  verbose = TRUE,
  trunc = TRUE
)
}
\arguments{
\item{concentration}{\code{numeric} is a vector of drug concentrations.}

\item{viability}{\code{numeric} is a vector whose entries are the viability values observed in the presence of the
drug concentrations whose logarithms are in the corresponding entries of conc, where viability 0
indicates that all cells died, and viability 1 indicates that the drug had no effect on the cells.}

\item{Hill_fit}{\code{list} or \code{vector} In the order: c("Hill Slope", "E_inf", "EC50"), the parameters of a Hill Slope
as returned by logLogisticRegression. If conc_as_log is set then the function assumes logEC50 is passed in, and if
viability_as_pct flag is set, it assumes E_inf is passed in as a percent. Otherwise, E_inf is assumed to be a decimal,
and EC50 as a concentration.}

\item{conc_as_log}{\code{logical}, if true, assumes that log10-concentration data has been given rather than concentration data,
and that log10(ICn) should be returned instead of ICn.}

\item{viability_as_pct}{\code{logical}, if false, assumes that viability is given as a decimal rather
than a percentage, and that E_inf passed in as decimal.}

\item{verbose}{\code{logical}, if true, causes warnings thrown by the function to be printed.}

\item{trunc}{\code{logical}, if true, causes viability data to be truncated to lie between 0 and 1 before
curve-fitting is performed.}

\item{n}{\code{numeric} The percentile concentration to compute. If viability_as_pct set, assumed to be percentage, otherwise
assumed to be a decimal value.}
}
\value{
\code{numeric(1)} The ICn of the Hill curve over the specified dose
range.

a numeric value for the concentration of the nth precentile viability reduction
}
\description{
Returns the ICn for any given nth percentile when given concentration and viability as input, normalized by the concentration
range of the experiment. A Hill Slope is first fit to the data, and the ICn is inferred from the fitted curve. Alternatively, the parameters
of a Hill Slope returned by logLogisticRegression can be passed in if they already known.
}
\section{Functions}{
\itemize{
\item \code{computeIC50()}: Returns the IC50 of a Drug Dose response curve

}}
\examples{
dose <- c(0.0025,0.008,0.025,0.08,0.25,0.8,2.53,8) 
viability <- c(108.67,111,102.16,100.27,90,87,74,57)
computeIC50(dose, viability)
computeICn(dose, viability, n=10)

}
