% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_data_col_sel.R
\name{validate_and_rename_df}
\alias{validate_and_rename_df}
\title{Rename columns in a dataframe}
\usage{
validate_and_rename_df(
  df,
  selections,
  col_config,
  others_cols = TRUE,
  na_strings = c("", "NA", "NULL")
)
}
\arguments{
\item{df}{A dataframe to be modified.}

\item{selections}{A named list of user-selected columns, the
names of the list must correspond to the new column names.}

\item{col_config}{A list of columns configuration
see \code{\link[=check_col_config]{check_col_config()}} for more details.}

\item{others_cols}{A boolean to authorize other columns to be
present in the output datatable.}
}
\value{
A dataframe with the selected columns renamed.
}
\description{
This function renames the columns of a dataframe based on the
user-selected columns.
It also validates the user-selected columns and ensures that
the mandatory columns are selected.
}
\examples{
df <- data.frame(
   ColN1 = c(1, 2), ColN2 = 4, ColTU1 = "A", ColTU2 = 3
)
Pedixplorer:::validate_and_rename_df(
   df, list(Need1 = "ColN1", Sup2 = "ColTU1"),
   list(
       Need1 = list(
           alternate = c("ColN1", "ColN3"), mandatory = TRUE,
           help = NULL
       ),
       Sup2 = list(
           alternate = c("ColTU1", "ColTU3"), mandatory = FALSE,
           help = "Supplementary column"
      )
   )
)
}
\keyword{internal}
