% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_famid.R
\name{upd_famid}
\alias{upd_famid}
\alias{upd_famid,character,ANY-method}
\alias{upd_famid,Ped,character_OR_integer-method}
\alias{upd_famid,Ped,missing-method}
\alias{upd_famid,Rel,character_OR_integer-method}
\alias{upd_famid,Rel,missing-method}
\alias{upd_famid,Pedigree,character_OR_integer-method}
\alias{upd_famid,Pedigree,missing-method}
\title{Update family prefix in individuals id}
\usage{
\S4method{upd_famid}{character,ANY}(obj, famid, missid = NA_character_)

\S4method{upd_famid}{Ped,character_OR_integer}(obj, famid)

\S4method{upd_famid}{Ped,missing}(obj)

\S4method{upd_famid}{Rel,character_OR_integer}(obj, famid)

\S4method{upd_famid}{Rel,missing}(obj)

\S4method{upd_famid}{Pedigree,character_OR_integer}(obj, famid)

\S4method{upd_famid}{Pedigree,missing}(obj)
}
\arguments{
\item{obj}{Ped or Pedigree object or a character vector of individual ids}

\item{famid}{A character vector with the family identifiers of the
individuals. If provide, will be aggregated to the individuals
identifiers separated by an underscore.}

\item{missid}{A character vector with the missing values identifiers.
All the id, dadid and momid corresponding to those values will be set
to \code{NA_character_}.}
}
\value{
A character vector of individual ids with family prefix
updated
}
\description{
Update the family prefix in the individuals identifiers.
Individuals identifiers are constructed as follow \strong{famid}_\strong{id}.
Therefore to update their family prefix the ids are split by the
first underscore and the first part is overwritten by \strong{famid}.
}
\details{
If famid is \emph{missing}, then the \code{famid()} function will be called
on the object.
}
\examples{

upd_famid(c("1", "2", "B_3"), c("A", "B", "A"))
upd_famid(c("1", "B_2", "C_3", "4"), c("A", NA, "A", NA))

data(sampleped)
ped1 <- Pedigree(sampleped[,-1])
id(ped(ped1))
new_fam <- make_famid(id(ped(ped1)), dadid(ped(ped1)), momid(ped(ped1)))
id(ped(upd_famid(ped1, new_fam)))

data(sampleped)
ped1 <- Pedigree(sampleped[,-1])
make_famid(ped1)
}
