% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_plot_legend.R
\name{plot_legend_ui}
\alias{plot_legend_ui}
\alias{plot_legend_server}
\alias{plot_legend_demo}
\title{Shiny module to generate pedigree graph legend.}
\usage{
plot_legend_ui(id, height = "400px")

plot_legend_server(
  id,
  pedi,
  leg_loc = c(0, 1, 0, 1),
  lwd = par("lwd"),
  boxw = 0.1,
  boxh = 0.1,
  adjx = 0,
  adjy = 0
)

plot_legend_demo(height = "400px", leg_loc = c(0.2, 0.8, 0.2, 0.6))
}
\arguments{
\item{id}{A string.}

\item{pedi}{A reactive pedigree object.}

\item{lwd}{default=1.  Controls the bordering line width of the
elements in the legend.}

\item{boxw}{Width of the polygons elements}

\item{boxh}{Height of the polygons elements}

\item{adjx}{default=0.  Controls the horizontal text adjustment of
the labels in the legend.}

\item{adjy}{default=0.  Controls the vertical text adjustment
of the labels in the legend.}
}
\value{
A static UI with the legend.
}
\description{
This module allows to plot the legend of a pedigree object.
The function is composed of two parts: the UI and the server.
The UI is called with the function \code{plot_legend_ui()} and the server
with the function \code{plot_legend_server()}.
}
\examples{
if (interactive()) {
    plot_legend_demo()
}
}
\keyword{internal}
