% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{ped_shiny}
\alias{ped_shiny}
\title{Run Pedixplorer Shiny application}
\usage{
ped_shiny(
  port = getOption("shiny.port"),
  host = getOption("shiny.host", "127.0.0.1"),
  precision = 6,
  ind_max_warning = 300,
  ind_max_error = 500
)
}
\arguments{
\item{port}{(optional) Specify port the application should list to.}

\item{host}{(optional) The IPv4 address that the application should
listen on.}

\item{precision}{Number of decimal for the position of the boxes
in the plot.}

\item{ind_max_warning}{An integer to define the maximum number of individuals
to plot before throwing a warning.
If the number of individuals is greater than this value,
the user will be asked to confirm the plot.}

\item{ind_max_error}{An integer to define the maximum number of individuals
to plot before throwing an error.
If the number of individuals is greater than this value,
an error will be thrown and the plot will not be computed.}
}
\value{
Running Shiny Application
}
\description{
This function creates a shiny application to manage and visualize
pedigree data using the \code{ped_ui()} and \code{ped_server()} functions.
}
\details{
The application is composed of several modules:
\itemize{
\item Data import
\item Data column selection
\item Data download
\item Family selection
\item Health selection
\item Informative selection
\item Subfamily selection
\item Plotting pedigree
\item Family information
}
}
\examples{
if (interactive()) {
    ped_shiny()
}
}
