% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_child.R
\name{num_child}
\alias{num_child}
\alias{num_child,character_OR_integer-method}
\alias{num_child,Pedigree-method}
\title{Number of childs}
\usage{
\S4method{num_child}{character_OR_integer}(obj, dadid, momid, rel_df = NULL, missid = NA_character_)

\S4method{num_child}{Pedigree}(obj, reset = FALSE)
}
\arguments{
\item{obj}{A character vector with the id of the individuals or a
\code{data.frame} with all the informations in corresponding columns.}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}

\item{rel_df}{A data.frame with the special relationships between
individuals. See \code{\link[=Rel]{Rel()}} for more informations.
The minimum columns required are \code{id1}, \code{id2} and \code{code}.
The \code{famid} column can also be used to specify the family
of the individuals.
If a matrix is given, the columns needs to be ordered as
\code{id1}, \code{id2}, \code{code} and \code{famid}.
The code values are:
\itemize{
\item \code{1} = Monozygotic twin
\item \code{2} = Dizygotic twin
\item \code{3} = twin of unknown zygosity
\item \code{4} = Spouse
}

The value relation code recognized by the function are the one defined
by the \code{\link[=rel_code_to_factor]{rel_code_to_factor()}} function.}

\item{missid}{A character vector with the missing values identifiers.
All the id, dadid and momid corresponding to those values will be set
to \code{NA_character_}.}

\item{reset}{If TRUE, the \code{num_child_tot}, \code{num_child_ind} and
the \code{num_child_dir} columns are reset.}
}
\value{
\subsection{When obj is a vector}{

A dataframe with the columns \code{num_child_dir}, \code{num_child_ind} and
\code{num_child_tot} giving respectively the direct, indirect and total number
of child.
}

\subsection{When obj is a Pedigree object}{

An updated Pedigree object with the columns \code{num_child_dir},
\code{num_child_ind} and \code{num_child_tot} added to the
Pedigree \code{ped} slot.
}
}
\description{
Compute the number of childs per individual
}
\details{
Compute the number of direct child but also the number
of indirect child given by the ones related with the linked spouses.
If a relation ship dataframe is given, then even if no children is present
between 2 spouses, the indirect childs will still be added.
}
\examples{

num_child(
    obj = c("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"),
    dadid = c("3", "3", "6", "8", "0", "0", "0", "0", "0", "0"),
    momid = c("4", "5", "7", "9", "0", "0", "0", "0", "0", "0"),
    rel_df = data.frame(
        id1 = "10",
        id2 = "3",
        code = "Spouse"
    )
)

data(sampleped)
ped1 <- Pedigree(sampleped[sampleped$famid == "1",])
ped1 <- num_child(ped1, reset = TRUE)
summary(ped(ped1))
}
