% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_famid.R
\name{make_famid}
\alias{make_famid}
\alias{make_famid,character-method}
\alias{make_famid,Pedigree-method}
\title{Compute family id}
\usage{
\S4method{make_famid}{character}(obj, dadid, momid)

\S4method{make_famid}{Pedigree}(obj)
}
\arguments{
\item{obj}{A character vector with the id of the individuals or a
\code{data.frame} with all the informations in corresponding columns.}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}
}
\value{
\subsection{When used with a character vector}{

An integer vector giving family groupings
}

\subsection{When used with a Pedigree object}{

An updated Pedigree object with the family id added
and with all ids updated
}
}
\description{
Construct a family identifier from pedigree information
}
\details{
Create a vector of length n, giving the family 'tree' number of each
subject.  If the Pedigree is totally connected, then everyone will end up in
tree 1, otherwise the tree numbers represent the disconnected subfamilies.
Singleton subjects give a zero for family number.
}
\examples{

make_famid(
    c("A", "B", "C", "D", "E", "F"),
    c("C", "D", "0", "0", "0", "0"),
    c("E", "E", "0", "0", "0", "0")
)

data(sampleped)
ped1 <- Pedigree(sampleped[,-1])
make_famid(ped1)
}
\seealso{
\code{\link[=kinship]{kinship()}}
}
