% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kindepth.R
\name{kindepth}
\alias{kindepth}
\alias{kindepth,character_OR_integer-method}
\alias{kindepth,Pedigree-method}
\alias{kindepth,Ped-method}
\title{Individual's depth in a pedigree}
\usage{
\S4method{kindepth}{character_OR_integer}(obj, dadid, momid, align_parents = FALSE, force = FALSE)

\S4method{kindepth}{Pedigree}(obj, align_parents = FALSE, force = FALSE)

\S4method{kindepth}{Ped}(obj, align_parents = FALSE, force = FALSE)
}
\arguments{
\item{obj}{A character vector with the id of the individuals or a
\code{data.frame} with all the informations in corresponding columns.}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}

\item{align_parents}{If \code{align_parents = TRUE}, go one step further
and try to make both parents of each child have the same depth.
(This is not always possible).
It helps the drawing program by lining up pedigrees that
'join in the middle' via a marriage.}

\item{force}{If \code{force = TRUE}, the function will return the depth minus
\code{min(depth)} if \code{depth} reach a state with no founders
is not possible.}
}
\value{
An integer vector containing the depth for each subject
}
\description{
Computes the depth of each subject in the Pedigree.
}
\details{
Mark each person as to their depth in a Pedigree; \code{0} for a founder,
otherwise :

\deqn{depth = 1 + \max(fatherDepth, motherDepth)}

In the case of an inbred Pedigree a perfect alignment may not exist.
}
\examples{
kindepth(
    c("A", "B", "C", "D", "E"),
    c("C", "D", "0", "0", "0"),
    c("E", "E", "0", "0", "0")
)
data(sampleped)
ped1 <- Pedigree(sampleped[sampleped$famid == "1",])
kindepth(ped1)
}
\seealso{
\code{\link[=align]{align()}}
}
\author{
Terry Therneau, updated by Louis Le Nezet
}
