% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fertility_to_factor}
\alias{fertility_to_factor}
\title{Fertility variable to factor}
\usage{
fertility_to_factor(fertility)
}
\arguments{
\item{fertility}{A character, factor or numeric vector corresponding to
the fertility status of the individuals. This will be transformed to a
factor with the following levels:
\code{infertile_choice_na}, \code{infertile}, \code{fertile}

The following values are recognized:
\itemize{
\item "inferile_choice_na" : "infertile_choice", "infertile_na"
\item "infertile" : "infertile", "steril", \code{FALSE}, \code{0}
\item "fertile" : "fertile", \code{TRUE}, \code{1}, \code{NA}
}}
}
\value{
a factor vector containing the transformed variable
"infertile_choice_na", "infertile", "fertile"
}
\description{
Transform a fertility variable to a factor variable
By default, all other values are transformed to \code{NA} and considered as
fertile.
}
\examples{
fertility_to_factor(c(
   1, "fertile", TRUE, NA,
  "infertile", "steril", FALSE, 0,
  "infertile_na", "infertile_choice_na", "infertile_choice"
))
}
\keyword{internal}
